@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.digitaltwins.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Specifies the authentication type being used for connecting to the endpoint. Defaults to 'KeyBased'. If 'KeyBased' is selected, a connection string must be specified (at least the primary connection string). If 'IdentityBased' is select, the endpointUri and entityPath properties must be specified.
 */
public enum class AuthenticationType(
    public val javaValue: com.pulumi.azurenative.digitaltwins.enums.AuthenticationType,
) : ConvertibleToJava<com.pulumi.azurenative.digitaltwins.enums.AuthenticationType> {
    KeyBased(com.pulumi.azurenative.digitaltwins.enums.AuthenticationType.KeyBased),
    IdentityBased(com.pulumi.azurenative.digitaltwins.enums.AuthenticationType.IdentityBased),
    ;

    override fun toJava(): com.pulumi.azurenative.digitaltwins.enums.AuthenticationType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.digitaltwins.enums.AuthenticationType): AuthenticationType = AuthenticationType.values().first { it.javaValue == javaType }
    }
}
