@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.digitaltwins.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Specifies whether or not to record twin / relationship property and item removals, including removals of indexed or keyed values (such as map entries, array elements, etc.). This feature is de-activated unless explicitly set to 'true'. Setting this property to 'true' will generate an additional column in the property events table in ADX.
 */
public enum class RecordPropertyAndItemRemovals(
    public val javaValue: com.pulumi.azurenative.digitaltwins.enums.RecordPropertyAndItemRemovals,
) : ConvertibleToJava<com.pulumi.azurenative.digitaltwins.enums.RecordPropertyAndItemRemovals> {
    True_(com.pulumi.azurenative.digitaltwins.enums.RecordPropertyAndItemRemovals.True_),
    False_(com.pulumi.azurenative.digitaltwins.enums.RecordPropertyAndItemRemovals.False_),
    ;

    override fun toJava(): com.pulumi.azurenative.digitaltwins.enums.RecordPropertyAndItemRemovals =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.digitaltwins.enums.RecordPropertyAndItemRemovals): RecordPropertyAndItemRemovals =
            RecordPropertyAndItemRemovals.values().first { it.javaValue == javaType }
    }
}
