@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.digitaltwins.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The properties of a private endpoint connection.
 * @property groupIds The list of group ids for the private endpoint connection.
 * @property privateEndpoint The private endpoint.
 * @property privateLinkServiceConnectionState The connection state.
 * @property provisioningState The provisioning state.
 */
public data class ConnectionPropertiesResponse(
    public val groupIds: List<String>? = null,
    public val privateEndpoint: PrivateEndpointResponse? = null,
    public val privateLinkServiceConnectionState: ConnectionPropertiesResponsePrivateLinkServiceConnectionState? = null,
    public val provisioningState: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.digitaltwins.outputs.ConnectionPropertiesResponse): ConnectionPropertiesResponse = ConnectionPropertiesResponse(
            groupIds = javaType.groupIds().map({ args0 -> args0 }),
            privateEndpoint = javaType.privateEndpoint().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.digitaltwins.kotlin.outputs.PrivateEndpointResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            privateLinkServiceConnectionState = javaType.privateLinkServiceConnectionState().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.digitaltwins.kotlin.outputs.ConnectionPropertiesResponsePrivateLinkServiceConnectionState.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
        )
    }
}
