@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.digitaltwins.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The connection state.
 * @property actionsRequired Actions required for a private endpoint connection.
 * @property description The description for the current state of a private endpoint connection.
 * @property status The status of a private endpoint connection.
 */
public data class ConnectionPropertiesResponsePrivateLinkServiceConnectionState(
    public val actionsRequired: String? = null,
    public val description: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.digitaltwins.outputs.ConnectionPropertiesResponsePrivateLinkServiceConnectionState): ConnectionPropertiesResponsePrivateLinkServiceConnectionState =
            ConnectionPropertiesResponsePrivateLinkServiceConnectionState(
                actionsRequired = javaType.actionsRequired().map({ args0 -> args0 }).orElse(null),
                description = javaType.description(),
                status = javaType.status(),
            )
    }
}
