@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.digitaltwins.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * The description of the DigitalTwins service.
 * @property createdTime Time when DigitalTwinsInstance was created.
 * @property hostName Api endpoint to work with DigitalTwinsInstance.
 * @property id The resource identifier.
 * @property identity The managed identity for the DigitalTwinsInstance.
 * @property lastUpdatedTime Time when DigitalTwinsInstance was updated.
 * @property location The resource location.
 * @property name The resource name.
 * @property privateEndpointConnections The private endpoint connections.
 * @property provisioningState The provisioning state.
 * @property publicNetworkAccess Public network access for the DigitalTwinsInstance.
 * @property systemData Metadata pertaining to creation and last modification of the DigitalTwinsInstance.
 * @property tags The resource tags.
 * @property type The resource type.
 */
public data class GetDigitalTwinResult(
    public val createdTime: String,
    public val hostName: String,
    public val id: String,
    public val identity: DigitalTwinsIdentityResponse? = null,
    public val lastUpdatedTime: String,
    public val location: String,
    public val name: String,
    public val privateEndpointConnections: List<PrivateEndpointConnectionResponse>? = null,
    public val provisioningState: String,
    public val publicNetworkAccess: String? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.digitaltwins.outputs.GetDigitalTwinResult): GetDigitalTwinResult = GetDigitalTwinResult(
            createdTime = javaType.createdTime(),
            hostName = javaType.hostName(),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.digitaltwins.kotlin.outputs.DigitalTwinsIdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            lastUpdatedTime = javaType.lastUpdatedTime(),
            location = javaType.location(),
            name = javaType.name(),
            privateEndpointConnections = javaType.privateEndpointConnections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.digitaltwins.kotlin.outputs.PrivateEndpointConnectionResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            publicNetworkAccess = javaType.publicNetworkAccess().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.digitaltwins.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
