@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.digitaltwins.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * DigitalTwinsInstance endpoint resource.
 * @property id The resource identifier.
 * @property name Extension resource name.
 * @property properties DigitalTwinsInstance endpoint resource properties.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property type The resource type.
 */
public data class GetDigitalTwinsEndpointResult(
    public val id: String,
    public val name: String,
    public val properties: Any,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.digitaltwins.outputs.GetDigitalTwinsEndpointResult): GetDigitalTwinsEndpointResult = GetDigitalTwinsEndpointResult(
            id = javaType.id(),
            name = javaType.name(),
            properties = javaType.properties(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.digitaltwins.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
