@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.digitaltwins.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The properties of the Managed Identity.
 * @property type The type of managed identity used.
 * @property userAssignedIdentity The user identity ARM resource id if the managed identity type is 'UserAssigned'.
 */
public data class ManagedIdentityReferenceResponse(
    public val type: String? = null,
    public val userAssignedIdentity: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.digitaltwins.outputs.ManagedIdentityReferenceResponse): ManagedIdentityReferenceResponse = ManagedIdentityReferenceResponse(
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
            userAssignedIdentity = javaType.userAssignedIdentity().map({ args0 -> args0 }).orElse(null),
        )
    }
}
