@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin

import com.pulumi.azurenative.documentdb.CassandraDataCenterArgs.builder
import com.pulumi.azurenative.documentdb.kotlin.inputs.DataCenterResourcePropertiesArgs
import com.pulumi.azurenative.documentdb.kotlin.inputs.DataCenterResourcePropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * A managed Cassandra data center.
 * Azure REST API version: 2023-04-15. Prior API version in Azure Native 1.x: 2021-03-01-preview.
 * Other available API versions: 2023-09-15, 2023-09-15-preview, 2023-11-15, 2023-11-15-preview, 2024-02-15-preview, 2024-05-15, 2024-05-15-preview.
 * ## Example Usage
 * ### CosmosDBManagedCassandraDataCenterCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cassandraDataCenter = new AzureNative.DocumentDB.CassandraDataCenter("cassandraDataCenter", new()
 *     {
 *         ClusterName = "cassandra-prod",
 *         DataCenterName = "dc1",
 *         Properties = new AzureNative.DocumentDB.Inputs.DataCenterResourcePropertiesArgs
 *         {
 *             Base64EncodedCassandraYamlFragment = "Y29tcGFjdGlvbl90aHJvdWdocHV0X21iX3Blcl9zZWM6IDMyCmNvbXBhY3Rpb25fbGFyZ2VfcGFydGl0aW9uX3dhcm5pbmdfdGhyZXNob2xkX21iOiAxMDA=",
 *             DataCenterLocation = "West US 2",
 *             DelegatedSubnetId = "/subscriptions/536e130b-d7d6-4ac7-98a5-de20d69588d2/resourceGroups/customer-vnet-rg/providers/Microsoft.Network/virtualNetworks/customer-vnet/subnets/dc1-subnet",
 *             NodeCount = 9,
 *         },
 *         ResourceGroupName = "cassandra-prod-rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/documentdb/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := documentdb.NewCassandraDataCenter(ctx, "cassandraDataCenter", &documentdb.CassandraDataCenterArgs{
 * 			ClusterName:    pulumi.String("cassandra-prod"),
 * 			DataCenterName: pulumi.String("dc1"),
 * 			Properties: &documentdb.DataCenterResourcePropertiesArgs{
 * 				Base64EncodedCassandraYamlFragment: pulumi.String("Y29tcGFjdGlvbl90aHJvdWdocHV0X21iX3Blcl9zZWM6IDMyCmNvbXBhY3Rpb25fbGFyZ2VfcGFydGl0aW9uX3dhcm5pbmdfdGhyZXNob2xkX21iOiAxMDA="),
 * 				DataCenterLocation:                 pulumi.String("West US 2"),
 * 				DelegatedSubnetId:                  pulumi.String("/subscriptions/536e130b-d7d6-4ac7-98a5-de20d69588d2/resourceGroups/customer-vnet-rg/providers/Microsoft.Network/virtualNetworks/customer-vnet/subnets/dc1-subnet"),
 * 				NodeCount:                          pulumi.Int(9),
 * 			},
 * 			ResourceGroupName: pulumi.String("cassandra-prod-rg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.documentdb.CassandraDataCenter;
 * import com.pulumi.azurenative.documentdb.CassandraDataCenterArgs;
 * import com.pulumi.azurenative.documentdb.inputs.DataCenterResourcePropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cassandraDataCenter = new CassandraDataCenter("cassandraDataCenter", CassandraDataCenterArgs.builder()
 *             .clusterName("cassandra-prod")
 *             .dataCenterName("dc1")
 *             .properties(DataCenterResourcePropertiesArgs.builder()
 *                 .base64EncodedCassandraYamlFragment("Y29tcGFjdGlvbl90aHJvdWdocHV0X21iX3Blcl9zZWM6IDMyCmNvbXBhY3Rpb25fbGFyZ2VfcGFydGl0aW9uX3dhcm5pbmdfdGhyZXNob2xkX21iOiAxMDA=")
 *                 .dataCenterLocation("West US 2")
 *                 .delegatedSubnetId("/subscriptions/536e130b-d7d6-4ac7-98a5-de20d69588d2/resourceGroups/customer-vnet-rg/providers/Microsoft.Network/virtualNetworks/customer-vnet/subnets/dc1-subnet")
 *                 .nodeCount(9)
 *                 .build())
 *             .resourceGroupName("cassandra-prod-rg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:documentdb:CassandraDataCenter dc1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/cassandraClusters/{clusterName}/dataCenters/{dataCenterName}
 * ```
 * @property clusterName Managed Cassandra cluster name.
 * @property dataCenterName Data center name in a managed Cassandra cluster.
 * @property properties Properties of a managed Cassandra data center.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class CassandraDataCenterArgs(
    public val clusterName: Output<String>? = null,
    public val dataCenterName: Output<String>? = null,
    public val properties: Output<DataCenterResourcePropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.CassandraDataCenterArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.CassandraDataCenterArgs =
        com.pulumi.azurenative.documentdb.CassandraDataCenterArgs.builder()
            .clusterName(clusterName?.applyValue({ args0 -> args0 }))
            .dataCenterName(dataCenterName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CassandraDataCenterArgs].
 */
@PulumiTagMarker
public class CassandraDataCenterArgsBuilder internal constructor() {
    private var clusterName: Output<String>? = null

    private var dataCenterName: Output<String>? = null

    private var properties: Output<DataCenterResourcePropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value Managed Cassandra cluster name.
     */
    @JvmName("edhfgsqiwmywnpgs")
    public suspend fun clusterName(`value`: Output<String>) {
        this.clusterName = value
    }

    /**
     * @param value Data center name in a managed Cassandra cluster.
     */
    @JvmName("xqddservmctqknpf")
    public suspend fun dataCenterName(`value`: Output<String>) {
        this.dataCenterName = value
    }

    /**
     * @param value Properties of a managed Cassandra data center.
     */
    @JvmName("bbofvennftjnsrng")
    public suspend fun properties(`value`: Output<DataCenterResourcePropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("mfappxarxbhcqppq")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Managed Cassandra cluster name.
     */
    @JvmName("oxyjsrnxpfkbafwg")
    public suspend fun clusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterName = mapped
    }

    /**
     * @param value Data center name in a managed Cassandra cluster.
     */
    @JvmName("ewtglohciscmiuvf")
    public suspend fun dataCenterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataCenterName = mapped
    }

    /**
     * @param value Properties of a managed Cassandra data center.
     */
    @JvmName("oihuvxmssjmxquld")
    public suspend fun properties(`value`: DataCenterResourcePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Properties of a managed Cassandra data center.
     */
    @JvmName("psktdmjmujbsmeid")
    public suspend fun properties(argument: suspend DataCenterResourcePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = DataCenterResourcePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("miwrivumsmqemwce")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): CassandraDataCenterArgs = CassandraDataCenterArgs(
        clusterName = clusterName,
        dataCenterName = dataCenterName,
        properties = properties,
        resourceGroupName = resourceGroupName,
    )
}
