@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin

import com.pulumi.azurenative.documentdb.kotlin.outputs.CassandraViewGetPropertiesResponseOptions
import com.pulumi.azurenative.documentdb.kotlin.outputs.CassandraViewGetPropertiesResponseResource
import com.pulumi.azurenative.documentdb.kotlin.outputs.ManagedServiceIdentityResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.documentdb.kotlin.outputs.CassandraViewGetPropertiesResponseOptions.Companion.toKotlin as cassandraViewGetPropertiesResponseOptionsToKotlin
import com.pulumi.azurenative.documentdb.kotlin.outputs.CassandraViewGetPropertiesResponseResource.Companion.toKotlin as cassandraViewGetPropertiesResponseResourceToKotlin
import com.pulumi.azurenative.documentdb.kotlin.outputs.ManagedServiceIdentityResponse.Companion.toKotlin as managedServiceIdentityResponseToKotlin

/**
 * Builder for [CassandraResourceCassandraView].
 */
@PulumiTagMarker
public class CassandraResourceCassandraViewResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CassandraResourceCassandraViewArgs = CassandraResourceCassandraViewArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CassandraResourceCassandraViewArgsBuilder.() -> Unit) {
        val builder = CassandraResourceCassandraViewArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): CassandraResourceCassandraView {
        val builtJavaResource =
            com.pulumi.azurenative.documentdb.CassandraResourceCassandraView(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return CassandraResourceCassandraView(builtJavaResource)
    }
}

/**
 * An Azure Cosmos DB Cassandra view.
 * Azure REST API version: 2023-03-15-preview. Prior API version in Azure Native 1.x: 2021-07-01-preview.
 * Other available API versions: 2023-09-15-preview, 2023-11-15-preview, 2024-02-15-preview, 2024-05-15-preview.
 * ## Example Usage
 * ### CosmosDBCassandraViewCreateUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cassandraResourceCassandraView = new AzureNative.DocumentDB.CassandraResourceCassandraView("cassandraResourceCassandraView", new()
 *     {
 *         AccountName = "ddb1",
 *         KeyspaceName = "keyspacename",
 *         Options = null,
 *         Resource = new AzureNative.DocumentDB.Inputs.CassandraViewResourceArgs
 *         {
 *             Id = "viewname",
 *             ViewDefinition = "SELECT columna, columnb, columnc FROM keyspacename.srctablename WHERE columna IS NOT NULL AND columnc IS NOT NULL PRIMARY (columnc, columna)",
 *         },
 *         ResourceGroupName = "rg1",
 *         Tags = null,
 *         ViewName = "viewname",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/documentdb/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := documentdb.NewCassandraResourceCassandraView(ctx, "cassandraResourceCassandraView", &documentdb.CassandraResourceCassandraViewArgs{
 * 			AccountName:  pulumi.String("ddb1"),
 * 			KeyspaceName: pulumi.String("keyspacename"),
 * 			Options:      nil,
 * 			Resource: &documentdb.CassandraViewResourceArgs{
 * 				Id:             pulumi.String("viewname"),
 * 				ViewDefinition: pulumi.String("SELECT columna, columnb, columnc FROM keyspacename.srctablename WHERE columna IS NOT NULL AND columnc IS NOT NULL PRIMARY (columnc, columna)"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Tags:              nil,
 * 			ViewName:          pulumi.String("viewname"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.documentdb.CassandraResourceCassandraView;
 * import com.pulumi.azurenative.documentdb.CassandraResourceCassandraViewArgs;
 * import com.pulumi.azurenative.documentdb.inputs.CreateUpdateOptionsArgs;
 * import com.pulumi.azurenative.documentdb.inputs.CassandraViewResourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cassandraResourceCassandraView = new CassandraResourceCassandraView("cassandraResourceCassandraView", CassandraResourceCassandraViewArgs.builder()
 *             .accountName("ddb1")
 *             .keyspaceName("keyspacename")
 *             .options()
 *             .resource(CassandraViewResourceArgs.builder()
 *                 .id("viewname")
 *                 .viewDefinition("SELECT columna, columnb, columnc FROM keyspacename.srctablename WHERE columna IS NOT NULL AND columnc IS NOT NULL PRIMARY (columnc, columna)")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .tags()
 *             .viewName("viewname")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:documentdb:CassandraResourceCassandraView viewname /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/cassandraKeyspaces/{keyspaceName}/views/{viewName}
 * ```
 */
public class CassandraResourceCassandraView internal constructor(
    override val javaResource: com.pulumi.azurenative.documentdb.CassandraResourceCassandraView,
) : KotlinCustomResource(javaResource, CassandraResourceCassandraViewMapper) {
    /**
     * Identity for the resource.
     */
    public val identity: Output<ManagedServiceIdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    managedServiceIdentityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The location of the resource group to which the resource belongs.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the ARM resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    public val options: Output<CassandraViewGetPropertiesResponseOptions>?
        get() = javaResource.options().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    cassandraViewGetPropertiesResponseOptionsToKotlin(args0)
                })
            }).orElse(null)
        })

    public val resource: Output<CassandraViewGetPropertiesResponseResource>?
        get() = javaResource.resource().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    cassandraViewGetPropertiesResponseResourceToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example, the default experience for a template type is set with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of Azure resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object CassandraResourceCassandraViewMapper : ResourceMapper<CassandraResourceCassandraView> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.documentdb.CassandraResourceCassandraView::class == javaResource::class

    override fun map(javaResource: Resource): CassandraResourceCassandraView =
        CassandraResourceCassandraView(
            javaResource as
                com.pulumi.azurenative.documentdb.CassandraResourceCassandraView,
        )
}

/**
 * @see [CassandraResourceCassandraView].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CassandraResourceCassandraView].
 */
public suspend fun cassandraResourceCassandraView(
    name: String,
    block: suspend CassandraResourceCassandraViewResourceBuilder.() -> Unit,
): CassandraResourceCassandraView {
    val builder = CassandraResourceCassandraViewResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CassandraResourceCassandraView].
 * @param name The _unique_ name of the resulting resource.
 */
public fun cassandraResourceCassandraView(name: String): CassandraResourceCassandraView {
    val builder = CassandraResourceCassandraViewResourceBuilder()
    builder.name(name)
    return builder.build()
}
