@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin

import com.pulumi.azurenative.documentdb.kotlin.outputs.AnalyticalStorageConfigurationResponse
import com.pulumi.azurenative.documentdb.kotlin.outputs.ApiPropertiesResponse
import com.pulumi.azurenative.documentdb.kotlin.outputs.CapabilityResponse
import com.pulumi.azurenative.documentdb.kotlin.outputs.CapacityResponse
import com.pulumi.azurenative.documentdb.kotlin.outputs.ConsistencyPolicyResponse
import com.pulumi.azurenative.documentdb.kotlin.outputs.ContinuousModeBackupPolicyResponse
import com.pulumi.azurenative.documentdb.kotlin.outputs.CorsPolicyResponse
import com.pulumi.azurenative.documentdb.kotlin.outputs.DatabaseAccountKeysMetadataResponse
import com.pulumi.azurenative.documentdb.kotlin.outputs.FailoverPolicyResponse
import com.pulumi.azurenative.documentdb.kotlin.outputs.IpAddressOrRangeResponse
import com.pulumi.azurenative.documentdb.kotlin.outputs.LocationResponse
import com.pulumi.azurenative.documentdb.kotlin.outputs.ManagedServiceIdentityResponse
import com.pulumi.azurenative.documentdb.kotlin.outputs.PeriodicModeBackupPolicyResponse
import com.pulumi.azurenative.documentdb.kotlin.outputs.PrivateEndpointConnectionResponse
import com.pulumi.azurenative.documentdb.kotlin.outputs.RestoreParametersResponse
import com.pulumi.azurenative.documentdb.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.documentdb.kotlin.outputs.VirtualNetworkRuleResponse
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.documentdb.kotlin.outputs.AnalyticalStorageConfigurationResponse.Companion.toKotlin as analyticalStorageConfigurationResponseToKotlin
import com.pulumi.azurenative.documentdb.kotlin.outputs.ApiPropertiesResponse.Companion.toKotlin as apiPropertiesResponseToKotlin
import com.pulumi.azurenative.documentdb.kotlin.outputs.CapabilityResponse.Companion.toKotlin as capabilityResponseToKotlin
import com.pulumi.azurenative.documentdb.kotlin.outputs.CapacityResponse.Companion.toKotlin as capacityResponseToKotlin
import com.pulumi.azurenative.documentdb.kotlin.outputs.ConsistencyPolicyResponse.Companion.toKotlin as consistencyPolicyResponseToKotlin
import com.pulumi.azurenative.documentdb.kotlin.outputs.CorsPolicyResponse.Companion.toKotlin as corsPolicyResponseToKotlin
import com.pulumi.azurenative.documentdb.kotlin.outputs.DatabaseAccountKeysMetadataResponse.Companion.toKotlin as databaseAccountKeysMetadataResponseToKotlin
import com.pulumi.azurenative.documentdb.kotlin.outputs.FailoverPolicyResponse.Companion.toKotlin as failoverPolicyResponseToKotlin
import com.pulumi.azurenative.documentdb.kotlin.outputs.IpAddressOrRangeResponse.Companion.toKotlin as ipAddressOrRangeResponseToKotlin
import com.pulumi.azurenative.documentdb.kotlin.outputs.LocationResponse.Companion.toKotlin as locationResponseToKotlin
import com.pulumi.azurenative.documentdb.kotlin.outputs.ManagedServiceIdentityResponse.Companion.toKotlin as managedServiceIdentityResponseToKotlin
import com.pulumi.azurenative.documentdb.kotlin.outputs.PrivateEndpointConnectionResponse.Companion.toKotlin as privateEndpointConnectionResponseToKotlin
import com.pulumi.azurenative.documentdb.kotlin.outputs.RestoreParametersResponse.Companion.toKotlin as restoreParametersResponseToKotlin
import com.pulumi.azurenative.documentdb.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.documentdb.kotlin.outputs.VirtualNetworkRuleResponse.Companion.toKotlin as virtualNetworkRuleResponseToKotlin

/**
 * Builder for [DatabaseAccount].
 */
@PulumiTagMarker
public class DatabaseAccountResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DatabaseAccountArgs = DatabaseAccountArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DatabaseAccountArgsBuilder.() -> Unit) {
        val builder = DatabaseAccountArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DatabaseAccount {
        val builtJavaResource =
            com.pulumi.azurenative.documentdb.DatabaseAccount(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return DatabaseAccount(builtJavaResource)
    }
}

/**
 * An Azure Cosmos DB database account.
 * Azure REST API version: 2023-04-15. Prior API version in Azure Native 1.x: 2021-03-15.
 * Other available API versions: 2020-03-01, 2020-06-01-preview, 2020-09-01, 2021-04-01-preview, 2023-03-15-preview, 2023-09-15, 2023-09-15-preview, 2023-11-15, 2023-11-15-preview, 2024-02-15-preview, 2024-05-15, 2024-05-15-preview.
 * ## Example Usage
 * ### CosmosDBDatabaseAccountCreateMin
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var databaseAccount = new AzureNative.DocumentDB.DatabaseAccount("databaseAccount", new()
 *     {
 *         AccountName = "ddb1",
 *         CreateMode = AzureNative.DocumentDB.CreateMode.Default,
 *         DatabaseAccountOfferType = AzureNative.DocumentDB.DatabaseAccountOfferType.Standard,
 *         Location = "westus",
 *         Locations = new[]
 *         {
 *             new AzureNative.DocumentDB.Inputs.LocationArgs
 *             {
 *                 FailoverPriority = 0,
 *                 IsZoneRedundant = false,
 *                 LocationName = "southcentralus",
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/documentdb/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := documentdb.NewDatabaseAccount(ctx, "databaseAccount", &documentdb.DatabaseAccountArgs{
 * 			AccountName:              pulumi.String("ddb1"),
 * 			CreateMode:               pulumi.String(documentdb.CreateModeDefault),
 * 			DatabaseAccountOfferType: documentdb.DatabaseAccountOfferTypeStandard,
 * 			Location:                 pulumi.String("westus"),
 * 			Locations: documentdb.LocationArray{
 * 				&documentdb.LocationArgs{
 * 					FailoverPriority: pulumi.Int(0),
 * 					IsZoneRedundant:  pulumi.Bool(false),
 * 					LocationName:     pulumi.String("southcentralus"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.documentdb.DatabaseAccount;
 * import com.pulumi.azurenative.documentdb.DatabaseAccountArgs;
 * import com.pulumi.azurenative.documentdb.inputs.LocationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var databaseAccount = new DatabaseAccount("databaseAccount", DatabaseAccountArgs.builder()
 *             .accountName("ddb1")
 *             .createMode("Default")
 *             .databaseAccountOfferType("Standard")
 *             .location("westus")
 *             .locations(LocationArgs.builder()
 *                 .failoverPriority(0)
 *                 .isZoneRedundant(false)
 *                 .locationName("southcentralus")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ### CosmosDBRestoreDatabaseAccountCreateUpdate.json
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var databaseAccount = new AzureNative.DocumentDB.DatabaseAccount("databaseAccount", new()
 *     {
 *         AccountName = "ddb1",
 *         ApiProperties = new AzureNative.DocumentDB.Inputs.ApiPropertiesArgs
 *         {
 *             ServerVersion = AzureNative.DocumentDB.ServerVersion.ServerVersion_3_2,
 *         },
 *         BackupPolicy = new AzureNative.DocumentDB.Inputs.ContinuousModeBackupPolicyArgs
 *         {
 *             ContinuousModeProperties = new AzureNative.DocumentDB.Inputs.ContinuousModePropertiesArgs
 *             {
 *                 Tier = AzureNative.DocumentDB.ContinuousTier.Continuous30Days,
 *             },
 *             Type = "Continuous",
 *         },
 *         ConsistencyPolicy = new AzureNative.DocumentDB.Inputs.ConsistencyPolicyArgs
 *         {
 *             DefaultConsistencyLevel = AzureNative.DocumentDB.DefaultConsistencyLevel.BoundedStaleness,
 *             MaxIntervalInSeconds = 10,
 *             MaxStalenessPrefix = 200,
 *         },
 *         CreateMode = "Restore",
 *         DatabaseAccountOfferType = AzureNative.DocumentDB.DatabaseAccountOfferType.Standard,
 *         EnableAnalyticalStorage = true,
 *         EnableFreeTier = false,
 *         KeyVaultKeyUri = "https://myKeyVault.vault.azure.net",
 *         Kind = AzureNative.DocumentDB.DatabaseAccountKind.GlobalDocumentDB,
 *         Location = "westus",
 *         Locations = new[]
 *         {
 *             new AzureNative.DocumentDB.Inputs.LocationArgs
 *             {
 *                 FailoverPriority = 0,
 *                 IsZoneRedundant = false,
 *                 LocationName = "southcentralus",
 *             },
 *         },
 *         MinimalTlsVersion = AzureNative.DocumentDB.MinimalTlsVersion.Tls,
 *         ResourceGroupName = "rg1",
 *         RestoreParameters = new AzureNative.DocumentDB.Inputs.RestoreParametersArgs
 *         {
 *             DatabasesToRestore = new[]
 *             {
 *                 new AzureNative.DocumentDB.Inputs.DatabaseRestoreResourceArgs
 *                 {
 *                     CollectionNames = new[]
 *                     {
 *                         "collection1",
 *                         "collection2",
 *                     },
 *                     DatabaseName = "db1",
 *                 },
 *                 new AzureNative.DocumentDB.Inputs.DatabaseRestoreResourceArgs
 *                 {
 *                     CollectionNames = new[]
 *                     {
 *                         "collection3",
 *                         "collection4",
 *                     },
 *                     DatabaseName = "db2",
 *                 },
 *             },
 *             RestoreMode = AzureNative.DocumentDB.RestoreMode.PointInTime,
 *             RestoreSource = "/subscriptions/subid/providers/Microsoft.DocumentDB/locations/westus/restorableDatabaseAccounts/1a97b4bb-f6a0-430e-ade1-638d781830cc",
 *             RestoreTimestampInUtc = "2021-03-11T22:05:09Z",
 *         },
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/documentdb/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := documentdb.NewDatabaseAccount(ctx, "databaseAccount", &documentdb.DatabaseAccountArgs{
 * 			AccountName: pulumi.String("ddb1"),
 * 			ApiProperties: &documentdb.ApiPropertiesArgs{
 * 				ServerVersion: pulumi.String(documentdb.ServerVersion_3_2),
 * 			},
 * 			BackupPolicy: documentdb.ContinuousModeBackupPolicy{
 * 				ContinuousModeProperties: documentdb.ContinuousModeProperties{
 * 					Tier: documentdb.ContinuousTierContinuous30Days,
 * 				},
 * 				Type: "Continuous",
 * 			},
 * 			ConsistencyPolicy: &documentdb.ConsistencyPolicyArgs{
 * 				DefaultConsistencyLevel: documentdb.DefaultConsistencyLevelBoundedStaleness,
 * 				MaxIntervalInSeconds:    pulumi.Int(10),
 * 				MaxStalenessPrefix:      pulumi.Float64(200),
 * 			},
 * 			CreateMode:               pulumi.String("Restore"),
 * 			DatabaseAccountOfferType: documentdb.DatabaseAccountOfferTypeStandard,
 * 			EnableAnalyticalStorage:  pulumi.Bool(true),
 * 			EnableFreeTier:           pulumi.Bool(false),
 * 			KeyVaultKeyUri:           pulumi.String("https://myKeyVault.vault.azure.net"),
 * 			Kind:                     pulumi.String(documentdb.DatabaseAccountKindGlobalDocumentDB),
 * 			Location:                 pulumi.String("westus"),
 * 			Locations: documentdb.LocationArray{
 * 				&documentdb.LocationArgs{
 * 					FailoverPriority: pulumi.Int(0),
 * 					IsZoneRedundant:  pulumi.Bool(false),
 * 					LocationName:     pulumi.String("southcentralus"),
 * 				},
 * 			},
 * 			MinimalTlsVersion: pulumi.String(documentdb.MinimalTlsVersionTls),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			RestoreParameters: &documentdb.RestoreParametersArgs{
 * 				DatabasesToRestore: documentdb.DatabaseRestoreResourceArray{
 * 					&documentdb.DatabaseRestoreResourceArgs{
 * 						CollectionNames: pulumi.StringArray{
 * 							pulumi.String("collection1"),
 * 							pulumi.String("collection2"),
 * 						},
 * 						DatabaseName: pulumi.String("db1"),
 * 					},
 * 					&documentdb.DatabaseRestoreResourceArgs{
 * 						CollectionNames: pulumi.StringArray{
 * 							pulumi.String("collection3"),
 * 							pulumi.String("collection4"),
 * 						},
 * 						DatabaseName: pulumi.String("db2"),
 * 					},
 * 				},
 * 				RestoreMode:           pulumi.String(documentdb.RestoreModePointInTime),
 * 				RestoreSource:         pulumi.String("/subscriptions/subid/providers/Microsoft.DocumentDB/locations/westus/restorableDatabaseAccounts/1a97b4bb-f6a0-430e-ade1-638d781830cc"),
 * 				RestoreTimestampInUtc: pulumi.String("2021-03-11T22:05:09Z"),
 * 			},
 * 			Tags: nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.documentdb.DatabaseAccount;
 * import com.pulumi.azurenative.documentdb.DatabaseAccountArgs;
 * import com.pulumi.azurenative.documentdb.inputs.ApiPropertiesArgs;
 * import com.pulumi.azurenative.documentdb.inputs.ConsistencyPolicyArgs;
 * import com.pulumi.azurenative.documentdb.inputs.LocationArgs;
 * import com.pulumi.azurenative.documentdb.inputs.RestoreParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var databaseAccount = new DatabaseAccount("databaseAccount", DatabaseAccountArgs.builder()
 *             .accountName("ddb1")
 *             .apiProperties(ApiPropertiesArgs.builder()
 *                 .serverVersion("3.2")
 *                 .build())
 *             .backupPolicy(ContinuousModeBackupPolicyArgs.builder()
 *                 .continuousModeProperties(ContinuousModePropertiesArgs.builder()
 *                     .tier("Continuous30Days")
 *                     .build())
 *                 .type("Continuous")
 *                 .build())
 *             .consistencyPolicy(ConsistencyPolicyArgs.builder()
 *                 .defaultConsistencyLevel("BoundedStaleness")
 *                 .maxIntervalInSeconds(10)
 *                 .maxStalenessPrefix(200)
 *                 .build())
 *             .createMode("Restore")
 *             .databaseAccountOfferType("Standard")
 *             .enableAnalyticalStorage(true)
 *             .enableFreeTier(false)
 *             .keyVaultKeyUri("https://myKeyVault.vault.azure.net")
 *             .kind("GlobalDocumentDB")
 *             .location("westus")
 *             .locations(LocationArgs.builder()
 *                 .failoverPriority(0)
 *                 .isZoneRedundant(false)
 *                 .locationName("southcentralus")
 *                 .build())
 *             .minimalTlsVersion("Tls")
 *             .resourceGroupName("rg1")
 *             .restoreParameters(RestoreParametersArgs.builder()
 *                 .databasesToRestore(
 *                     DatabaseRestoreResourceArgs.builder()
 *                         .collectionNames(
 *                             "collection1",
 *                             "collection2")
 *                         .databaseName("db1")
 *                         .build(),
 *                     DatabaseRestoreResourceArgs.builder()
 *                         .collectionNames(
 *                             "collection3",
 *                             "collection4")
 *                         .databaseName("db2")
 *                         .build())
 *                 .restoreMode("PointInTime")
 *                 .restoreSource("/subscriptions/subid/providers/Microsoft.DocumentDB/locations/westus/restorableDatabaseAccounts/1a97b4bb-f6a0-430e-ade1-638d781830cc")
 *                 .restoreTimestampInUtc("2021-03-11T22:05:09Z")
 *                 .build())
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:documentdb:DatabaseAccount ddb1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}
 * ```
 */
public class DatabaseAccount internal constructor(
    override val javaResource: com.pulumi.azurenative.documentdb.DatabaseAccount,
) : KotlinCustomResource(javaResource, DatabaseAccountMapper) {
    /**
     * Analytical storage specific properties.
     */
    public val analyticalStorageConfiguration: Output<AnalyticalStorageConfigurationResponse>?
        get() = javaResource.analyticalStorageConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> analyticalStorageConfigurationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * API specific properties.
     */
    public val apiProperties: Output<ApiPropertiesResponse>?
        get() = javaResource.apiProperties().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> apiPropertiesResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The object representing the policy for taking backups on an account.
     */
    public val backupPolicy:
        Output<Either<ContinuousModeBackupPolicyResponse, PeriodicModeBackupPolicyResponse>>?
        get() = javaResource.backupPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.documentdb.kotlin.outputs.ContinuousModeBackupPolicyResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.documentdb.kotlin.outputs.PeriodicModeBackupPolicyResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null)
        })

    /**
     * List of Cosmos DB capabilities for the account
     */
    public val capabilities: Output<List<CapabilityResponse>>?
        get() = javaResource.capabilities().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> capabilityResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The object that represents all properties related to capacity enforcement on an account.
     */
    public val capacity: Output<CapacityResponse>?
        get() = javaResource.capacity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    capacityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The cassandra connector offer type for the Cosmos DB database C* account.
     */
    public val connectorOffer: Output<String>?
        get() = javaResource.connectorOffer().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The consistency policy for the Cosmos DB database account.
     */
    public val consistencyPolicy: Output<ConsistencyPolicyResponse>?
        get() = javaResource.consistencyPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> consistencyPolicyResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The CORS policy for the Cosmos DB database account.
     */
    public val cors: Output<List<CorsPolicyResponse>>?
        get() = javaResource.cors().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> corsPolicyResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Enum to indicate the mode of account creation.
     */
    public val createMode: Output<String>?
        get() = javaResource.createMode().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The offer type for the Cosmos DB database account. Default value: Standard.
     */
    public val databaseAccountOfferType: Output<String>
        get() = javaResource.databaseAccountOfferType().applyValue({ args0 -> args0 })

    /**
     * The default identity for accessing key vault used in features like customer managed keys. The default identity needs to be explicitly set by the users. It can be "FirstPartyIdentity", "SystemAssignedIdentity" and more.
     */
    public val defaultIdentity: Output<String>?
        get() = javaResource.defaultIdentity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Disable write operations on metadata resources (databases, containers, throughput) via account keys
     */
    public val disableKeyBasedMetadataWriteAccess: Output<Boolean>?
        get() = javaResource.disableKeyBasedMetadataWriteAccess().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    /**
     * Opt-out of local authentication and ensure only MSI and AAD can be used exclusively for authentication.
     */
    public val disableLocalAuth: Output<Boolean>?
        get() = javaResource.disableLocalAuth().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The connection endpoint for the Cosmos DB database account.
     */
    public val documentEndpoint: Output<String>
        get() = javaResource.documentEndpoint().applyValue({ args0 -> args0 })

    /**
     * Flag to indicate whether to enable storage analytics.
     */
    public val enableAnalyticalStorage: Output<Boolean>?
        get() = javaResource.enableAnalyticalStorage().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enables automatic failover of the write region in the rare event that the region is unavailable due to an outage. Automatic failover will result in a new write region for the account and is chosen based on the failover priorities configured for the account.
     */
    public val enableAutomaticFailover: Output<Boolean>?
        get() = javaResource.enableAutomaticFailover().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enables the cassandra connector on the Cosmos DB C* account
     */
    public val enableCassandraConnector: Output<Boolean>?
        get() = javaResource.enableCassandraConnector().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Flag to indicate whether Free Tier is enabled.
     */
    public val enableFreeTier: Output<Boolean>?
        get() = javaResource.enableFreeTier().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enables the account to write in multiple locations
     */
    public val enableMultipleWriteLocations: Output<Boolean>?
        get() = javaResource.enableMultipleWriteLocations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Flag to indicate enabling/disabling of Partition Merge feature on the account
     */
    public val enablePartitionMerge: Output<Boolean>?
        get() = javaResource.enablePartitionMerge().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * An array that contains the regions ordered by their failover priorities.
     */
    public val failoverPolicies: Output<List<FailoverPolicyResponse>>
        get() = javaResource.failoverPolicies().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> failoverPolicyResponseToKotlin(args0) })
            })
        })

    /**
     * Identity for the resource.
     */
    public val identity: Output<ManagedServiceIdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    managedServiceIdentityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * A unique identifier assigned to the database account
     */
    public val instanceId: Output<String>
        get() = javaResource.instanceId().applyValue({ args0 -> args0 })

    /**
     * List of IpRules.
     */
    public val ipRules: Output<List<IpAddressOrRangeResponse>>?
        get() = javaResource.ipRules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> ipAddressOrRangeResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Flag to indicate whether to enable/disable Virtual Network ACL rules.
     */
    public val isVirtualNetworkFilterEnabled: Output<Boolean>?
        get() = javaResource.isVirtualNetworkFilterEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The URI of the key vault
     */
    public val keyVaultKeyUri: Output<String>?
        get() = javaResource.keyVaultKeyUri().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The object that represents the metadata for the Account Keys of the Cosmos DB account.
     */
    public val keysMetadata: Output<DatabaseAccountKeysMetadataResponse>
        get() = javaResource.keysMetadata().applyValue({ args0 ->
            args0.let({ args0 ->
                databaseAccountKeysMetadataResponseToKotlin(args0)
            })
        })

    /**
     * Indicates the type of database account. This can only be set at database account creation.
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The location of the resource group to which the resource belongs.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * An array that contains all of the locations enabled for the Cosmos DB account.
     */
    public val locations: Output<List<LocationResponse>>
        get() = javaResource.locations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    locationResponseToKotlin(args0)
                })
            })
        })

    /**
     * Indicates the minimum allowed Tls version. The default value is Tls 1.2. Cassandra and Mongo APIs only work with Tls 1.2.
     */
    public val minimalTlsVersion: Output<String>?
        get() = javaResource.minimalTlsVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the ARM resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Indicates what services are allowed to bypass firewall checks.
     */
    public val networkAclBypass: Output<String>?
        get() = javaResource.networkAclBypass().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * An array that contains the Resource Ids for Network Acl Bypass for the Cosmos DB account.
     */
    public val networkAclBypassResourceIds: Output<List<String>>?
        get() = javaResource.networkAclBypassResourceIds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * List of Private Endpoint Connections configured for the Cosmos DB account.
     */
    public val privateEndpointConnections: Output<List<PrivateEndpointConnectionResponse>>
        get() = javaResource.privateEndpointConnections().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> privateEndpointConnectionResponseToKotlin(args0) })
            })
        })

    /**
     * The status of the Cosmos DB account at the time the operation was called. The status can be one of following. 'Creating' – the Cosmos DB account is being created. When an account is in Creating state, only properties that are specified as input for the Create Cosmos DB account operation are returned. 'Succeeded' – the Cosmos DB account is active for use. 'Updating' – the Cosmos DB account is being updated. 'Deleting' – the Cosmos DB account is being deleted. 'Failed' – the Cosmos DB account failed creation. 'DeletionFailed' – the Cosmos DB account deletion failed.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Whether requests from Public Network are allowed
     */
    public val publicNetworkAccess: Output<String>?
        get() = javaResource.publicNetworkAccess().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * An array that contains of the read locations enabled for the Cosmos DB account.
     */
    public val readLocations: Output<List<LocationResponse>>
        get() = javaResource.readLocations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> locationResponseToKotlin(args0) })
            })
        })

    /**
     * Parameters to indicate the information about the restore.
     */
    public val restoreParameters: Output<RestoreParametersResponse>?
        get() = javaResource.restoreParameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> restoreParametersResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The system meta data relating to this resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example, the default experience for a template type is set with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of Azure resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * List of Virtual Network ACL rules configured for the Cosmos DB account.
     */
    public val virtualNetworkRules: Output<List<VirtualNetworkRuleResponse>>?
        get() = javaResource.virtualNetworkRules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        virtualNetworkRuleResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * An array that contains the write location for the Cosmos DB account.
     */
    public val writeLocations: Output<List<LocationResponse>>
        get() = javaResource.writeLocations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> locationResponseToKotlin(args0) })
            })
        })
}

public object DatabaseAccountMapper : ResourceMapper<DatabaseAccount> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.documentdb.DatabaseAccount::class == javaResource::class

    override fun map(javaResource: Resource): DatabaseAccount = DatabaseAccount(
        javaResource as
            com.pulumi.azurenative.documentdb.DatabaseAccount,
    )
}

/**
 * @see [DatabaseAccount].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DatabaseAccount].
 */
public suspend fun databaseAccount(
    name: String,
    block: suspend DatabaseAccountResourceBuilder.() -> Unit,
): DatabaseAccount {
    val builder = DatabaseAccountResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DatabaseAccount].
 * @param name The _unique_ name of the resulting resource.
 */
public fun databaseAccount(name: String): DatabaseAccount {
    val builder = DatabaseAccountResourceBuilder()
    builder.name(name)
    return builder.build()
}
