@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin

import com.pulumi.azurenative.documentdb.DatabaseAccountArgs.builder
import com.pulumi.azurenative.documentdb.kotlin.enums.ConnectorOffer
import com.pulumi.azurenative.documentdb.kotlin.enums.CreateMode
import com.pulumi.azurenative.documentdb.kotlin.enums.DatabaseAccountKind
import com.pulumi.azurenative.documentdb.kotlin.enums.DatabaseAccountOfferType
import com.pulumi.azurenative.documentdb.kotlin.enums.MinimalTlsVersion
import com.pulumi.azurenative.documentdb.kotlin.enums.NetworkAclBypass
import com.pulumi.azurenative.documentdb.kotlin.enums.PublicNetworkAccess
import com.pulumi.azurenative.documentdb.kotlin.inputs.AnalyticalStorageConfigurationArgs
import com.pulumi.azurenative.documentdb.kotlin.inputs.AnalyticalStorageConfigurationArgsBuilder
import com.pulumi.azurenative.documentdb.kotlin.inputs.ApiPropertiesArgs
import com.pulumi.azurenative.documentdb.kotlin.inputs.ApiPropertiesArgsBuilder
import com.pulumi.azurenative.documentdb.kotlin.inputs.CapabilityArgs
import com.pulumi.azurenative.documentdb.kotlin.inputs.CapabilityArgsBuilder
import com.pulumi.azurenative.documentdb.kotlin.inputs.CapacityArgs
import com.pulumi.azurenative.documentdb.kotlin.inputs.CapacityArgsBuilder
import com.pulumi.azurenative.documentdb.kotlin.inputs.ConsistencyPolicyArgs
import com.pulumi.azurenative.documentdb.kotlin.inputs.ConsistencyPolicyArgsBuilder
import com.pulumi.azurenative.documentdb.kotlin.inputs.ContinuousModeBackupPolicyArgs
import com.pulumi.azurenative.documentdb.kotlin.inputs.CorsPolicyArgs
import com.pulumi.azurenative.documentdb.kotlin.inputs.CorsPolicyArgsBuilder
import com.pulumi.azurenative.documentdb.kotlin.inputs.IpAddressOrRangeArgs
import com.pulumi.azurenative.documentdb.kotlin.inputs.IpAddressOrRangeArgsBuilder
import com.pulumi.azurenative.documentdb.kotlin.inputs.LocationArgs
import com.pulumi.azurenative.documentdb.kotlin.inputs.LocationArgsBuilder
import com.pulumi.azurenative.documentdb.kotlin.inputs.ManagedServiceIdentityArgs
import com.pulumi.azurenative.documentdb.kotlin.inputs.ManagedServiceIdentityArgsBuilder
import com.pulumi.azurenative.documentdb.kotlin.inputs.PeriodicModeBackupPolicyArgs
import com.pulumi.azurenative.documentdb.kotlin.inputs.RestoreParametersArgs
import com.pulumi.azurenative.documentdb.kotlin.inputs.RestoreParametersArgsBuilder
import com.pulumi.azurenative.documentdb.kotlin.inputs.VirtualNetworkRuleArgs
import com.pulumi.azurenative.documentdb.kotlin.inputs.VirtualNetworkRuleArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * An Azure Cosmos DB database account.
 * Azure REST API version: 2023-04-15. Prior API version in Azure Native 1.x: 2021-03-15.
 * Other available API versions: 2020-03-01, 2020-06-01-preview, 2020-09-01, 2021-04-01-preview, 2023-03-15-preview, 2023-09-15, 2023-09-15-preview, 2023-11-15, 2023-11-15-preview, 2024-02-15-preview, 2024-05-15, 2024-05-15-preview.
 * ## Example Usage
 * ### CosmosDBDatabaseAccountCreateMin
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var databaseAccount = new AzureNative.DocumentDB.DatabaseAccount("databaseAccount", new()
 *     {
 *         AccountName = "ddb1",
 *         CreateMode = AzureNative.DocumentDB.CreateMode.Default,
 *         DatabaseAccountOfferType = AzureNative.DocumentDB.DatabaseAccountOfferType.Standard,
 *         Location = "westus",
 *         Locations = new[]
 *         {
 *             new AzureNative.DocumentDB.Inputs.LocationArgs
 *             {
 *                 FailoverPriority = 0,
 *                 IsZoneRedundant = false,
 *                 LocationName = "southcentralus",
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/documentdb/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := documentdb.NewDatabaseAccount(ctx, "databaseAccount", &documentdb.DatabaseAccountArgs{
 * 			AccountName:              pulumi.String("ddb1"),
 * 			CreateMode:               pulumi.String(documentdb.CreateModeDefault),
 * 			DatabaseAccountOfferType: documentdb.DatabaseAccountOfferTypeStandard,
 * 			Location:                 pulumi.String("westus"),
 * 			Locations: documentdb.LocationArray{
 * 				&documentdb.LocationArgs{
 * 					FailoverPriority: pulumi.Int(0),
 * 					IsZoneRedundant:  pulumi.Bool(false),
 * 					LocationName:     pulumi.String("southcentralus"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.documentdb.DatabaseAccount;
 * import com.pulumi.azurenative.documentdb.DatabaseAccountArgs;
 * import com.pulumi.azurenative.documentdb.inputs.LocationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var databaseAccount = new DatabaseAccount("databaseAccount", DatabaseAccountArgs.builder()
 *             .accountName("ddb1")
 *             .createMode("Default")
 *             .databaseAccountOfferType("Standard")
 *             .location("westus")
 *             .locations(LocationArgs.builder()
 *                 .failoverPriority(0)
 *                 .isZoneRedundant(false)
 *                 .locationName("southcentralus")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ### CosmosDBRestoreDatabaseAccountCreateUpdate.json
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var databaseAccount = new AzureNative.DocumentDB.DatabaseAccount("databaseAccount", new()
 *     {
 *         AccountName = "ddb1",
 *         ApiProperties = new AzureNative.DocumentDB.Inputs.ApiPropertiesArgs
 *         {
 *             ServerVersion = AzureNative.DocumentDB.ServerVersion.ServerVersion_3_2,
 *         },
 *         BackupPolicy = new AzureNative.DocumentDB.Inputs.ContinuousModeBackupPolicyArgs
 *         {
 *             ContinuousModeProperties = new AzureNative.DocumentDB.Inputs.ContinuousModePropertiesArgs
 *             {
 *                 Tier = AzureNative.DocumentDB.ContinuousTier.Continuous30Days,
 *             },
 *             Type = "Continuous",
 *         },
 *         ConsistencyPolicy = new AzureNative.DocumentDB.Inputs.ConsistencyPolicyArgs
 *         {
 *             DefaultConsistencyLevel = AzureNative.DocumentDB.DefaultConsistencyLevel.BoundedStaleness,
 *             MaxIntervalInSeconds = 10,
 *             MaxStalenessPrefix = 200,
 *         },
 *         CreateMode = "Restore",
 *         DatabaseAccountOfferType = AzureNative.DocumentDB.DatabaseAccountOfferType.Standard,
 *         EnableAnalyticalStorage = true,
 *         EnableFreeTier = false,
 *         KeyVaultKeyUri = "https://myKeyVault.vault.azure.net",
 *         Kind = AzureNative.DocumentDB.DatabaseAccountKind.GlobalDocumentDB,
 *         Location = "westus",
 *         Locations = new[]
 *         {
 *             new AzureNative.DocumentDB.Inputs.LocationArgs
 *             {
 *                 FailoverPriority = 0,
 *                 IsZoneRedundant = false,
 *                 LocationName = "southcentralus",
 *             },
 *         },
 *         MinimalTlsVersion = AzureNative.DocumentDB.MinimalTlsVersion.Tls,
 *         ResourceGroupName = "rg1",
 *         RestoreParameters = new AzureNative.DocumentDB.Inputs.RestoreParametersArgs
 *         {
 *             DatabasesToRestore = new[]
 *             {
 *                 new AzureNative.DocumentDB.Inputs.DatabaseRestoreResourceArgs
 *                 {
 *                     CollectionNames = new[]
 *                     {
 *                         "collection1",
 *                         "collection2",
 *                     },
 *                     DatabaseName = "db1",
 *                 },
 *                 new AzureNative.DocumentDB.Inputs.DatabaseRestoreResourceArgs
 *                 {
 *                     CollectionNames = new[]
 *                     {
 *                         "collection3",
 *                         "collection4",
 *                     },
 *                     DatabaseName = "db2",
 *                 },
 *             },
 *             RestoreMode = AzureNative.DocumentDB.RestoreMode.PointInTime,
 *             RestoreSource = "/subscriptions/subid/providers/Microsoft.DocumentDB/locations/westus/restorableDatabaseAccounts/1a97b4bb-f6a0-430e-ade1-638d781830cc",
 *             RestoreTimestampInUtc = "2021-03-11T22:05:09Z",
 *         },
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/documentdb/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := documentdb.NewDatabaseAccount(ctx, "databaseAccount", &documentdb.DatabaseAccountArgs{
 * 			AccountName: pulumi.String("ddb1"),
 * 			ApiProperties: &documentdb.ApiPropertiesArgs{
 * 				ServerVersion: pulumi.String(documentdb.ServerVersion_3_2),
 * 			},
 * 			BackupPolicy: documentdb.ContinuousModeBackupPolicy{
 * 				ContinuousModeProperties: documentdb.ContinuousModeProperties{
 * 					Tier: documentdb.ContinuousTierContinuous30Days,
 * 				},
 * 				Type: "Continuous",
 * 			},
 * 			ConsistencyPolicy: &documentdb.ConsistencyPolicyArgs{
 * 				DefaultConsistencyLevel: documentdb.DefaultConsistencyLevelBoundedStaleness,
 * 				MaxIntervalInSeconds:    pulumi.Int(10),
 * 				MaxStalenessPrefix:      pulumi.Float64(200),
 * 			},
 * 			CreateMode:               pulumi.String("Restore"),
 * 			DatabaseAccountOfferType: documentdb.DatabaseAccountOfferTypeStandard,
 * 			EnableAnalyticalStorage:  pulumi.Bool(true),
 * 			EnableFreeTier:           pulumi.Bool(false),
 * 			KeyVaultKeyUri:           pulumi.String("https://myKeyVault.vault.azure.net"),
 * 			Kind:                     pulumi.String(documentdb.DatabaseAccountKindGlobalDocumentDB),
 * 			Location:                 pulumi.String("westus"),
 * 			Locations: documentdb.LocationArray{
 * 				&documentdb.LocationArgs{
 * 					FailoverPriority: pulumi.Int(0),
 * 					IsZoneRedundant:  pulumi.Bool(false),
 * 					LocationName:     pulumi.String("southcentralus"),
 * 				},
 * 			},
 * 			MinimalTlsVersion: pulumi.String(documentdb.MinimalTlsVersionTls),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			RestoreParameters: &documentdb.RestoreParametersArgs{
 * 				DatabasesToRestore: documentdb.DatabaseRestoreResourceArray{
 * 					&documentdb.DatabaseRestoreResourceArgs{
 * 						CollectionNames: pulumi.StringArray{
 * 							pulumi.String("collection1"),
 * 							pulumi.String("collection2"),
 * 						},
 * 						DatabaseName: pulumi.String("db1"),
 * 					},
 * 					&documentdb.DatabaseRestoreResourceArgs{
 * 						CollectionNames: pulumi.StringArray{
 * 							pulumi.String("collection3"),
 * 							pulumi.String("collection4"),
 * 						},
 * 						DatabaseName: pulumi.String("db2"),
 * 					},
 * 				},
 * 				RestoreMode:           pulumi.String(documentdb.RestoreModePointInTime),
 * 				RestoreSource:         pulumi.String("/subscriptions/subid/providers/Microsoft.DocumentDB/locations/westus/restorableDatabaseAccounts/1a97b4bb-f6a0-430e-ade1-638d781830cc"),
 * 				RestoreTimestampInUtc: pulumi.String("2021-03-11T22:05:09Z"),
 * 			},
 * 			Tags: nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.documentdb.DatabaseAccount;
 * import com.pulumi.azurenative.documentdb.DatabaseAccountArgs;
 * import com.pulumi.azurenative.documentdb.inputs.ApiPropertiesArgs;
 * import com.pulumi.azurenative.documentdb.inputs.ConsistencyPolicyArgs;
 * import com.pulumi.azurenative.documentdb.inputs.LocationArgs;
 * import com.pulumi.azurenative.documentdb.inputs.RestoreParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var databaseAccount = new DatabaseAccount("databaseAccount", DatabaseAccountArgs.builder()
 *             .accountName("ddb1")
 *             .apiProperties(ApiPropertiesArgs.builder()
 *                 .serverVersion("3.2")
 *                 .build())
 *             .backupPolicy(ContinuousModeBackupPolicyArgs.builder()
 *                 .continuousModeProperties(ContinuousModePropertiesArgs.builder()
 *                     .tier("Continuous30Days")
 *                     .build())
 *                 .type("Continuous")
 *                 .build())
 *             .consistencyPolicy(ConsistencyPolicyArgs.builder()
 *                 .defaultConsistencyLevel("BoundedStaleness")
 *                 .maxIntervalInSeconds(10)
 *                 .maxStalenessPrefix(200)
 *                 .build())
 *             .createMode("Restore")
 *             .databaseAccountOfferType("Standard")
 *             .enableAnalyticalStorage(true)
 *             .enableFreeTier(false)
 *             .keyVaultKeyUri("https://myKeyVault.vault.azure.net")
 *             .kind("GlobalDocumentDB")
 *             .location("westus")
 *             .locations(LocationArgs.builder()
 *                 .failoverPriority(0)
 *                 .isZoneRedundant(false)
 *                 .locationName("southcentralus")
 *                 .build())
 *             .minimalTlsVersion("Tls")
 *             .resourceGroupName("rg1")
 *             .restoreParameters(RestoreParametersArgs.builder()
 *                 .databasesToRestore(
 *                     DatabaseRestoreResourceArgs.builder()
 *                         .collectionNames(
 *                             "collection1",
 *                             "collection2")
 *                         .databaseName("db1")
 *                         .build(),
 *                     DatabaseRestoreResourceArgs.builder()
 *                         .collectionNames(
 *                             "collection3",
 *                             "collection4")
 *                         .databaseName("db2")
 *                         .build())
 *                 .restoreMode("PointInTime")
 *                 .restoreSource("/subscriptions/subid/providers/Microsoft.DocumentDB/locations/westus/restorableDatabaseAccounts/1a97b4bb-f6a0-430e-ade1-638d781830cc")
 *                 .restoreTimestampInUtc("2021-03-11T22:05:09Z")
 *                 .build())
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:documentdb:DatabaseAccount ddb1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}
 * ```
 * @property accountName Cosmos DB database account name.
 * @property analyticalStorageConfiguration Analytical storage specific properties.
 * @property apiProperties API specific properties. Currently, supported only for MongoDB API.
 * @property backupPolicy The object representing the policy for taking backups on an account.
 * @property capabilities List of Cosmos DB capabilities for the account
 * @property capacity The object that represents all properties related to capacity enforcement on an account.
 * @property connectorOffer The cassandra connector offer type for the Cosmos DB database C* account.
 * @property consistencyPolicy The consistency policy for the Cosmos DB account.
 * @property cors The CORS policy for the Cosmos DB database account.
 * @property createMode Enum to indicate the mode of account creation.
 * @property databaseAccountOfferType The offer type for the database
 * @property defaultIdentity The default identity for accessing key vault used in features like customer managed keys. The default identity needs to be explicitly set by the users. It can be "FirstPartyIdentity", "SystemAssignedIdentity" and more.
 * @property disableKeyBasedMetadataWriteAccess Disable write operations on metadata resources (databases, containers, throughput) via account keys
 * @property disableLocalAuth Opt-out of local authentication and ensure only MSI and AAD can be used exclusively for authentication.
 * @property enableAnalyticalStorage Flag to indicate whether to enable storage analytics.
 * @property enableAutomaticFailover Enables automatic failover of the write region in the rare event that the region is unavailable due to an outage. Automatic failover will result in a new write region for the account and is chosen based on the failover priorities configured for the account.
 * @property enableCassandraConnector Enables the cassandra connector on the Cosmos DB C* account
 * @property enableFreeTier Flag to indicate whether Free Tier is enabled.
 * @property enableMultipleWriteLocations Enables the account to write in multiple locations
 * @property enablePartitionMerge Flag to indicate enabling/disabling of Partition Merge feature on the account
 * @property identity Identity for the resource.
 * @property ipRules List of IpRules.
 * @property isVirtualNetworkFilterEnabled Flag to indicate whether to enable/disable Virtual Network ACL rules.
 * @property keyVaultKeyUri The URI of the key vault
 * @property kind Indicates the type of database account. This can only be set at database account creation.
 * @property location The location of the resource group to which the resource belongs.
 * @property locations An array that contains the georeplication locations enabled for the Cosmos DB account.
 * @property minimalTlsVersion Indicates the minimum allowed Tls version. The default value is Tls 1.2. Cassandra and Mongo APIs only work with Tls 1.2.
 * @property networkAclBypass Indicates what services are allowed to bypass firewall checks.
 * @property networkAclBypassResourceIds An array that contains the Resource Ids for Network Acl Bypass for the Cosmos DB account.
 * @property publicNetworkAccess Whether requests from Public Network are allowed
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property restoreParameters Parameters to indicate the information about the restore.
 * @property tags Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example, the default experience for a template type is set with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
 * @property virtualNetworkRules List of Virtual Network ACL rules configured for the Cosmos DB account.
 */
public data class DatabaseAccountArgs(
    public val accountName: Output<String>? = null,
    public val analyticalStorageConfiguration: Output<AnalyticalStorageConfigurationArgs>? = null,
    public val apiProperties: Output<ApiPropertiesArgs>? = null,
    public val backupPolicy: Output<Either<ContinuousModeBackupPolicyArgs, PeriodicModeBackupPolicyArgs>>? = null,
    public val capabilities: Output<List<CapabilityArgs>>? = null,
    public val capacity: Output<CapacityArgs>? = null,
    public val connectorOffer: Output<Either<String, ConnectorOffer>>? = null,
    public val consistencyPolicy: Output<ConsistencyPolicyArgs>? = null,
    public val cors: Output<List<CorsPolicyArgs>>? = null,
    public val createMode: Output<Either<String, CreateMode>>? = null,
    public val databaseAccountOfferType: Output<DatabaseAccountOfferType>? = null,
    public val defaultIdentity: Output<String>? = null,
    public val disableKeyBasedMetadataWriteAccess: Output<Boolean>? = null,
    public val disableLocalAuth: Output<Boolean>? = null,
    public val enableAnalyticalStorage: Output<Boolean>? = null,
    public val enableAutomaticFailover: Output<Boolean>? = null,
    public val enableCassandraConnector: Output<Boolean>? = null,
    public val enableFreeTier: Output<Boolean>? = null,
    public val enableMultipleWriteLocations: Output<Boolean>? = null,
    public val enablePartitionMerge: Output<Boolean>? = null,
    public val identity: Output<ManagedServiceIdentityArgs>? = null,
    public val ipRules: Output<List<IpAddressOrRangeArgs>>? = null,
    public val isVirtualNetworkFilterEnabled: Output<Boolean>? = null,
    public val keyVaultKeyUri: Output<String>? = null,
    public val kind: Output<Either<String, DatabaseAccountKind>>? = null,
    public val location: Output<String>? = null,
    public val locations: Output<List<LocationArgs>>? = null,
    public val minimalTlsVersion: Output<Either<String, MinimalTlsVersion>>? = null,
    public val networkAclBypass: Output<NetworkAclBypass>? = null,
    public val networkAclBypassResourceIds: Output<List<String>>? = null,
    public val publicNetworkAccess: Output<Either<String, PublicNetworkAccess>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val restoreParameters: Output<RestoreParametersArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val virtualNetworkRules: Output<List<VirtualNetworkRuleArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.DatabaseAccountArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.DatabaseAccountArgs =
        com.pulumi.azurenative.documentdb.DatabaseAccountArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .analyticalStorageConfiguration(
                analyticalStorageConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .apiProperties(apiProperties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .backupPolicy(
                backupPolicy?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .capabilities(
                capabilities?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .capacity(capacity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .connectorOffer(
                connectorOffer?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .consistencyPolicy(consistencyPolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .cors(cors?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .createMode(
                createMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .databaseAccountOfferType(
                databaseAccountOfferType?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .defaultIdentity(defaultIdentity?.applyValue({ args0 -> args0 }))
            .disableKeyBasedMetadataWriteAccess(
                disableKeyBasedMetadataWriteAccess?.applyValue({ args0 ->
                    args0
                }),
            )
            .disableLocalAuth(disableLocalAuth?.applyValue({ args0 -> args0 }))
            .enableAnalyticalStorage(enableAnalyticalStorage?.applyValue({ args0 -> args0 }))
            .enableAutomaticFailover(enableAutomaticFailover?.applyValue({ args0 -> args0 }))
            .enableCassandraConnector(enableCassandraConnector?.applyValue({ args0 -> args0 }))
            .enableFreeTier(enableFreeTier?.applyValue({ args0 -> args0 }))
            .enableMultipleWriteLocations(enableMultipleWriteLocations?.applyValue({ args0 -> args0 }))
            .enablePartitionMerge(enablePartitionMerge?.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .ipRules(
                ipRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .isVirtualNetworkFilterEnabled(isVirtualNetworkFilterEnabled?.applyValue({ args0 -> args0 }))
            .keyVaultKeyUri(keyVaultKeyUri?.applyValue({ args0 -> args0 }))
            .kind(
                kind?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .locations(
                locations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .minimalTlsVersion(
                minimalTlsVersion?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .networkAclBypass(networkAclBypass?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .networkAclBypassResourceIds(
                networkAclBypassResourceIds?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .publicNetworkAccess(
                publicNetworkAccess?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .restoreParameters(restoreParameters?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .virtualNetworkRules(
                virtualNetworkRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [DatabaseAccountArgs].
 */
@PulumiTagMarker
public class DatabaseAccountArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var analyticalStorageConfiguration: Output<AnalyticalStorageConfigurationArgs>? = null

    private var apiProperties: Output<ApiPropertiesArgs>? = null

    private var backupPolicy:
        Output<Either<ContinuousModeBackupPolicyArgs, PeriodicModeBackupPolicyArgs>>? = null

    private var capabilities: Output<List<CapabilityArgs>>? = null

    private var capacity: Output<CapacityArgs>? = null

    private var connectorOffer: Output<Either<String, ConnectorOffer>>? = null

    private var consistencyPolicy: Output<ConsistencyPolicyArgs>? = null

    private var cors: Output<List<CorsPolicyArgs>>? = null

    private var createMode: Output<Either<String, CreateMode>>? = null

    private var databaseAccountOfferType: Output<DatabaseAccountOfferType>? = null

    private var defaultIdentity: Output<String>? = null

    private var disableKeyBasedMetadataWriteAccess: Output<Boolean>? = null

    private var disableLocalAuth: Output<Boolean>? = null

    private var enableAnalyticalStorage: Output<Boolean>? = null

    private var enableAutomaticFailover: Output<Boolean>? = null

    private var enableCassandraConnector: Output<Boolean>? = null

    private var enableFreeTier: Output<Boolean>? = null

    private var enableMultipleWriteLocations: Output<Boolean>? = null

    private var enablePartitionMerge: Output<Boolean>? = null

    private var identity: Output<ManagedServiceIdentityArgs>? = null

    private var ipRules: Output<List<IpAddressOrRangeArgs>>? = null

    private var isVirtualNetworkFilterEnabled: Output<Boolean>? = null

    private var keyVaultKeyUri: Output<String>? = null

    private var kind: Output<Either<String, DatabaseAccountKind>>? = null

    private var location: Output<String>? = null

    private var locations: Output<List<LocationArgs>>? = null

    private var minimalTlsVersion: Output<Either<String, MinimalTlsVersion>>? = null

    private var networkAclBypass: Output<NetworkAclBypass>? = null

    private var networkAclBypassResourceIds: Output<List<String>>? = null

    private var publicNetworkAccess: Output<Either<String, PublicNetworkAccess>>? = null

    private var resourceGroupName: Output<String>? = null

    private var restoreParameters: Output<RestoreParametersArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var virtualNetworkRules: Output<List<VirtualNetworkRuleArgs>>? = null

    /**
     * @param value Cosmos DB database account name.
     */
    @JvmName("ydnhwwesbkhpcwno")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value Analytical storage specific properties.
     */
    @JvmName("jnvbeojjaihnxiph")
    public suspend fun analyticalStorageConfiguration(`value`: Output<AnalyticalStorageConfigurationArgs>) {
        this.analyticalStorageConfiguration = value
    }

    /**
     * @param value API specific properties. Currently, supported only for MongoDB API.
     */
    @JvmName("ifdyexgsindjwsgt")
    public suspend fun apiProperties(`value`: Output<ApiPropertiesArgs>) {
        this.apiProperties = value
    }

    /**
     * @param value The object representing the policy for taking backups on an account.
     */
    @JvmName("dkogmuqypaukeodh")
    public suspend fun backupPolicy(`value`: Output<Either<ContinuousModeBackupPolicyArgs, PeriodicModeBackupPolicyArgs>>) {
        this.backupPolicy = value
    }

    /**
     * @param value List of Cosmos DB capabilities for the account
     */
    @JvmName("fygfnjxcxeeqwdtk")
    public suspend fun capabilities(`value`: Output<List<CapabilityArgs>>) {
        this.capabilities = value
    }

    @JvmName("kgemxhhwrngyebtv")
    public suspend fun capabilities(vararg values: Output<CapabilityArgs>) {
        this.capabilities = Output.all(values.asList())
    }

    /**
     * @param values List of Cosmos DB capabilities for the account
     */
    @JvmName("sqatxxxblxaadtud")
    public suspend fun capabilities(values: List<Output<CapabilityArgs>>) {
        this.capabilities = Output.all(values)
    }

    /**
     * @param value The object that represents all properties related to capacity enforcement on an account.
     */
    @JvmName("wwwlucvdhpkjkdll")
    public suspend fun capacity(`value`: Output<CapacityArgs>) {
        this.capacity = value
    }

    /**
     * @param value The cassandra connector offer type for the Cosmos DB database C* account.
     */
    @JvmName("vaaxdwgcvghhpfkm")
    public suspend fun connectorOffer(`value`: Output<Either<String, ConnectorOffer>>) {
        this.connectorOffer = value
    }

    /**
     * @param value The consistency policy for the Cosmos DB account.
     */
    @JvmName("alqjvatvtghtfyif")
    public suspend fun consistencyPolicy(`value`: Output<ConsistencyPolicyArgs>) {
        this.consistencyPolicy = value
    }

    /**
     * @param value The CORS policy for the Cosmos DB database account.
     */
    @JvmName("ajjaolgjuvnaopsg")
    public suspend fun cors(`value`: Output<List<CorsPolicyArgs>>) {
        this.cors = value
    }

    @JvmName("dskgocpwrbswxlso")
    public suspend fun cors(vararg values: Output<CorsPolicyArgs>) {
        this.cors = Output.all(values.asList())
    }

    /**
     * @param values The CORS policy for the Cosmos DB database account.
     */
    @JvmName("ugfkcjvqolqbsova")
    public suspend fun cors(values: List<Output<CorsPolicyArgs>>) {
        this.cors = Output.all(values)
    }

    /**
     * @param value Enum to indicate the mode of account creation.
     */
    @JvmName("ytwulckpfxuqwrxh")
    public suspend fun createMode(`value`: Output<Either<String, CreateMode>>) {
        this.createMode = value
    }

    /**
     * @param value The offer type for the database
     */
    @JvmName("imnbktusctarkihj")
    public suspend fun databaseAccountOfferType(`value`: Output<DatabaseAccountOfferType>) {
        this.databaseAccountOfferType = value
    }

    /**
     * @param value The default identity for accessing key vault used in features like customer managed keys. The default identity needs to be explicitly set by the users. It can be "FirstPartyIdentity", "SystemAssignedIdentity" and more.
     */
    @JvmName("clikohsbiutkpkqm")
    public suspend fun defaultIdentity(`value`: Output<String>) {
        this.defaultIdentity = value
    }

    /**
     * @param value Disable write operations on metadata resources (databases, containers, throughput) via account keys
     */
    @JvmName("vjfsyojxobrmovmu")
    public suspend fun disableKeyBasedMetadataWriteAccess(`value`: Output<Boolean>) {
        this.disableKeyBasedMetadataWriteAccess = value
    }

    /**
     * @param value Opt-out of local authentication and ensure only MSI and AAD can be used exclusively for authentication.
     */
    @JvmName("gpduypxxcvreanrt")
    public suspend fun disableLocalAuth(`value`: Output<Boolean>) {
        this.disableLocalAuth = value
    }

    /**
     * @param value Flag to indicate whether to enable storage analytics.
     */
    @JvmName("khjvvmqnhuxxhjee")
    public suspend fun enableAnalyticalStorage(`value`: Output<Boolean>) {
        this.enableAnalyticalStorage = value
    }

    /**
     * @param value Enables automatic failover of the write region in the rare event that the region is unavailable due to an outage. Automatic failover will result in a new write region for the account and is chosen based on the failover priorities configured for the account.
     */
    @JvmName("vlsypkbcjcwgidyd")
    public suspend fun enableAutomaticFailover(`value`: Output<Boolean>) {
        this.enableAutomaticFailover = value
    }

    /**
     * @param value Enables the cassandra connector on the Cosmos DB C* account
     */
    @JvmName("xmgssnalbmqmokcq")
    public suspend fun enableCassandraConnector(`value`: Output<Boolean>) {
        this.enableCassandraConnector = value
    }

    /**
     * @param value Flag to indicate whether Free Tier is enabled.
     */
    @JvmName("urxtpfhrnnevbrfa")
    public suspend fun enableFreeTier(`value`: Output<Boolean>) {
        this.enableFreeTier = value
    }

    /**
     * @param value Enables the account to write in multiple locations
     */
    @JvmName("wsftinurguglpfey")
    public suspend fun enableMultipleWriteLocations(`value`: Output<Boolean>) {
        this.enableMultipleWriteLocations = value
    }

    /**
     * @param value Flag to indicate enabling/disabling of Partition Merge feature on the account
     */
    @JvmName("qqapjlryyvuirkre")
    public suspend fun enablePartitionMerge(`value`: Output<Boolean>) {
        this.enablePartitionMerge = value
    }

    /**
     * @param value Identity for the resource.
     */
    @JvmName("lmtepoujgntslqdf")
    public suspend fun identity(`value`: Output<ManagedServiceIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value List of IpRules.
     */
    @JvmName("mevqhsqmmirforub")
    public suspend fun ipRules(`value`: Output<List<IpAddressOrRangeArgs>>) {
        this.ipRules = value
    }

    @JvmName("kacpwuadsdflrqdk")
    public suspend fun ipRules(vararg values: Output<IpAddressOrRangeArgs>) {
        this.ipRules = Output.all(values.asList())
    }

    /**
     * @param values List of IpRules.
     */
    @JvmName("ueianmcnpiilaqly")
    public suspend fun ipRules(values: List<Output<IpAddressOrRangeArgs>>) {
        this.ipRules = Output.all(values)
    }

    /**
     * @param value Flag to indicate whether to enable/disable Virtual Network ACL rules.
     */
    @JvmName("bwlxqiawikqgduwt")
    public suspend fun isVirtualNetworkFilterEnabled(`value`: Output<Boolean>) {
        this.isVirtualNetworkFilterEnabled = value
    }

    /**
     * @param value The URI of the key vault
     */
    @JvmName("seisxfyimsjbuohc")
    public suspend fun keyVaultKeyUri(`value`: Output<String>) {
        this.keyVaultKeyUri = value
    }

    /**
     * @param value Indicates the type of database account. This can only be set at database account creation.
     */
    @JvmName("glreqoupnhijbrtl")
    public suspend fun kind(`value`: Output<Either<String, DatabaseAccountKind>>) {
        this.kind = value
    }

    /**
     * @param value The location of the resource group to which the resource belongs.
     */
    @JvmName("dbcfikwyvmxkieno")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value An array that contains the georeplication locations enabled for the Cosmos DB account.
     */
    @JvmName("atdtwkxccuefeodu")
    public suspend fun locations(`value`: Output<List<LocationArgs>>) {
        this.locations = value
    }

    @JvmName("vbbelaqfpfwgyqtw")
    public suspend fun locations(vararg values: Output<LocationArgs>) {
        this.locations = Output.all(values.asList())
    }

    /**
     * @param values An array that contains the georeplication locations enabled for the Cosmos DB account.
     */
    @JvmName("ykupvatlaxkcjiqh")
    public suspend fun locations(values: List<Output<LocationArgs>>) {
        this.locations = Output.all(values)
    }

    /**
     * @param value Indicates the minimum allowed Tls version. The default value is Tls 1.2. Cassandra and Mongo APIs only work with Tls 1.2.
     */
    @JvmName("anfrgtfsjgtjtjhc")
    public suspend fun minimalTlsVersion(`value`: Output<Either<String, MinimalTlsVersion>>) {
        this.minimalTlsVersion = value
    }

    /**
     * @param value Indicates what services are allowed to bypass firewall checks.
     */
    @JvmName("wudekbedbknqlwog")
    public suspend fun networkAclBypass(`value`: Output<NetworkAclBypass>) {
        this.networkAclBypass = value
    }

    /**
     * @param value An array that contains the Resource Ids for Network Acl Bypass for the Cosmos DB account.
     */
    @JvmName("ektmrcylsuwfqcwk")
    public suspend fun networkAclBypassResourceIds(`value`: Output<List<String>>) {
        this.networkAclBypassResourceIds = value
    }

    @JvmName("gwulhanohruwbyut")
    public suspend fun networkAclBypassResourceIds(vararg values: Output<String>) {
        this.networkAclBypassResourceIds = Output.all(values.asList())
    }

    /**
     * @param values An array that contains the Resource Ids for Network Acl Bypass for the Cosmos DB account.
     */
    @JvmName("jcvvdcffrdeljwen")
    public suspend fun networkAclBypassResourceIds(values: List<Output<String>>) {
        this.networkAclBypassResourceIds = Output.all(values)
    }

    /**
     * @param value Whether requests from Public Network are allowed
     */
    @JvmName("xawheecduxsvygum")
    public suspend fun publicNetworkAccess(`value`: Output<Either<String, PublicNetworkAccess>>) {
        this.publicNetworkAccess = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("drtweypbxjckwdgs")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Parameters to indicate the information about the restore.
     */
    @JvmName("jdetwhqdcndxgypv")
    public suspend fun restoreParameters(`value`: Output<RestoreParametersArgs>) {
        this.restoreParameters = value
    }

    /**
     * @param value Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example, the default experience for a template type is set with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
     */
    @JvmName("hhmojiqhfpwqqulh")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value List of Virtual Network ACL rules configured for the Cosmos DB account.
     */
    @JvmName("ypmwnbdatwuihxaa")
    public suspend fun virtualNetworkRules(`value`: Output<List<VirtualNetworkRuleArgs>>) {
        this.virtualNetworkRules = value
    }

    @JvmName("odrkanbcrlsgegun")
    public suspend fun virtualNetworkRules(vararg values: Output<VirtualNetworkRuleArgs>) {
        this.virtualNetworkRules = Output.all(values.asList())
    }

    /**
     * @param values List of Virtual Network ACL rules configured for the Cosmos DB account.
     */
    @JvmName("ewjmclnmfrmqqiml")
    public suspend fun virtualNetworkRules(values: List<Output<VirtualNetworkRuleArgs>>) {
        this.virtualNetworkRules = Output.all(values)
    }

    /**
     * @param value Cosmos DB database account name.
     */
    @JvmName("khllirkshnepwoos")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value Analytical storage specific properties.
     */
    @JvmName("oofgangergxkirqy")
    public suspend fun analyticalStorageConfiguration(`value`: AnalyticalStorageConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.analyticalStorageConfiguration = mapped
    }

    /**
     * @param argument Analytical storage specific properties.
     */
    @JvmName("mjpwhbsdkfiosxmt")
    public suspend fun analyticalStorageConfiguration(argument: suspend AnalyticalStorageConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = AnalyticalStorageConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.analyticalStorageConfiguration = mapped
    }

    /**
     * @param value API specific properties. Currently, supported only for MongoDB API.
     */
    @JvmName("mygsxnbuwsjfsxia")
    public suspend fun apiProperties(`value`: ApiPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiProperties = mapped
    }

    /**
     * @param argument API specific properties. Currently, supported only for MongoDB API.
     */
    @JvmName("qodxgxytriycvcnu")
    public suspend fun apiProperties(argument: suspend ApiPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ApiPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.apiProperties = mapped
    }

    /**
     * @param value The object representing the policy for taking backups on an account.
     */
    @JvmName("qlgkfwbgnwislhjk")
    public suspend fun backupPolicy(`value`: Either<ContinuousModeBackupPolicyArgs, PeriodicModeBackupPolicyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupPolicy = mapped
    }

    /**
     * @param value The object representing the policy for taking backups on an account.
     */
    @JvmName("bndidruifijkbnbb")
    public fun backupPolicy(`value`: ContinuousModeBackupPolicyArgs) {
        val toBeMapped = Either.ofLeft<
            ContinuousModeBackupPolicyArgs,
            PeriodicModeBackupPolicyArgs,
            >(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backupPolicy = mapped
    }

    /**
     * @param value The object representing the policy for taking backups on an account.
     */
    @JvmName("imqekwjhiyikcdvm")
    public fun backupPolicy(`value`: PeriodicModeBackupPolicyArgs) {
        val toBeMapped = Either.ofRight<
            ContinuousModeBackupPolicyArgs,
            PeriodicModeBackupPolicyArgs,
            >(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backupPolicy = mapped
    }

    /**
     * @param value List of Cosmos DB capabilities for the account
     */
    @JvmName("iiwpohycxxlqjqon")
    public suspend fun capabilities(`value`: List<CapabilityArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capabilities = mapped
    }

    /**
     * @param argument List of Cosmos DB capabilities for the account
     */
    @JvmName("fbarcqqpaugmkmuw")
    public suspend fun capabilities(argument: List<suspend CapabilityArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { CapabilityArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.capabilities = mapped
    }

    /**
     * @param argument List of Cosmos DB capabilities for the account
     */
    @JvmName("mksrgxqifjysqvei")
    public suspend fun capabilities(vararg argument: suspend CapabilityArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { CapabilityArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.capabilities = mapped
    }

    /**
     * @param argument List of Cosmos DB capabilities for the account
     */
    @JvmName("klekcorfngrqgycm")
    public suspend fun capabilities(argument: suspend CapabilityArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(CapabilityArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.capabilities = mapped
    }

    /**
     * @param values List of Cosmos DB capabilities for the account
     */
    @JvmName("svfjlhivvxeajnev")
    public suspend fun capabilities(vararg values: CapabilityArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.capabilities = mapped
    }

    /**
     * @param value The object that represents all properties related to capacity enforcement on an account.
     */
    @JvmName("yqvcbsmordpcfitr")
    public suspend fun capacity(`value`: CapacityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacity = mapped
    }

    /**
     * @param argument The object that represents all properties related to capacity enforcement on an account.
     */
    @JvmName("vigfgiidlvmutdbu")
    public suspend fun capacity(argument: suspend CapacityArgsBuilder.() -> Unit) {
        val toBeMapped = CapacityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.capacity = mapped
    }

    /**
     * @param value The cassandra connector offer type for the Cosmos DB database C* account.
     */
    @JvmName("gtdkitjrwloeqyyk")
    public suspend fun connectorOffer(`value`: Either<String, ConnectorOffer>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectorOffer = mapped
    }

    /**
     * @param value The cassandra connector offer type for the Cosmos DB database C* account.
     */
    @JvmName("rtrfxshheopktcjp")
    public fun connectorOffer(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ConnectorOffer>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.connectorOffer = mapped
    }

    /**
     * @param value The cassandra connector offer type for the Cosmos DB database C* account.
     */
    @JvmName("fjvotpyfskanirxo")
    public fun connectorOffer(`value`: ConnectorOffer) {
        val toBeMapped = Either.ofRight<String, ConnectorOffer>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.connectorOffer = mapped
    }

    /**
     * @param value The consistency policy for the Cosmos DB account.
     */
    @JvmName("geucjalsjyesokgm")
    public suspend fun consistencyPolicy(`value`: ConsistencyPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.consistencyPolicy = mapped
    }

    /**
     * @param argument The consistency policy for the Cosmos DB account.
     */
    @JvmName("gukbesjfgywdgcys")
    public suspend fun consistencyPolicy(argument: suspend ConsistencyPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = ConsistencyPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.consistencyPolicy = mapped
    }

    /**
     * @param value The CORS policy for the Cosmos DB database account.
     */
    @JvmName("waufevtfvpemhxqe")
    public suspend fun cors(`value`: List<CorsPolicyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cors = mapped
    }

    /**
     * @param argument The CORS policy for the Cosmos DB database account.
     */
    @JvmName("kmqkbdnwbwtachme")
    public suspend fun cors(argument: List<suspend CorsPolicyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { CorsPolicyArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.cors = mapped
    }

    /**
     * @param argument The CORS policy for the Cosmos DB database account.
     */
    @JvmName("plmgklvrnrfievml")
    public suspend fun cors(vararg argument: suspend CorsPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { CorsPolicyArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.cors = mapped
    }

    /**
     * @param argument The CORS policy for the Cosmos DB database account.
     */
    @JvmName("qtwukkvaolxiawws")
    public suspend fun cors(argument: suspend CorsPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(CorsPolicyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.cors = mapped
    }

    /**
     * @param values The CORS policy for the Cosmos DB database account.
     */
    @JvmName("sdhomrnmjjbkdlbf")
    public suspend fun cors(vararg values: CorsPolicyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cors = mapped
    }

    /**
     * @param value Enum to indicate the mode of account creation.
     */
    @JvmName("vukkrometkxkxkku")
    public suspend fun createMode(`value`: Either<String, CreateMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.createMode = mapped
    }

    /**
     * @param value Enum to indicate the mode of account creation.
     */
    @JvmName("imnlfagoiqvafqmx")
    public fun createMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, CreateMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.createMode = mapped
    }

    /**
     * @param value Enum to indicate the mode of account creation.
     */
    @JvmName("rpprgbavmbffigcn")
    public fun createMode(`value`: CreateMode) {
        val toBeMapped = Either.ofRight<String, CreateMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.createMode = mapped
    }

    /**
     * @param value The offer type for the database
     */
    @JvmName("thjchenddpfakywf")
    public suspend fun databaseAccountOfferType(`value`: DatabaseAccountOfferType?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseAccountOfferType = mapped
    }

    /**
     * @param value The default identity for accessing key vault used in features like customer managed keys. The default identity needs to be explicitly set by the users. It can be "FirstPartyIdentity", "SystemAssignedIdentity" and more.
     */
    @JvmName("psypifeujpvduebc")
    public suspend fun defaultIdentity(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultIdentity = mapped
    }

    /**
     * @param value Disable write operations on metadata resources (databases, containers, throughput) via account keys
     */
    @JvmName("waivmfkriqlucejg")
    public suspend fun disableKeyBasedMetadataWriteAccess(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableKeyBasedMetadataWriteAccess = mapped
    }

    /**
     * @param value Opt-out of local authentication and ensure only MSI and AAD can be used exclusively for authentication.
     */
    @JvmName("cijqemjeslykljnc")
    public suspend fun disableLocalAuth(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableLocalAuth = mapped
    }

    /**
     * @param value Flag to indicate whether to enable storage analytics.
     */
    @JvmName("jujptawcebopqrnx")
    public suspend fun enableAnalyticalStorage(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableAnalyticalStorage = mapped
    }

    /**
     * @param value Enables automatic failover of the write region in the rare event that the region is unavailable due to an outage. Automatic failover will result in a new write region for the account and is chosen based on the failover priorities configured for the account.
     */
    @JvmName("nhphjhcvxskuoyge")
    public suspend fun enableAutomaticFailover(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableAutomaticFailover = mapped
    }

    /**
     * @param value Enables the cassandra connector on the Cosmos DB C* account
     */
    @JvmName("qbgadydkaaufspmd")
    public suspend fun enableCassandraConnector(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableCassandraConnector = mapped
    }

    /**
     * @param value Flag to indicate whether Free Tier is enabled.
     */
    @JvmName("hbmtfdhntdicavim")
    public suspend fun enableFreeTier(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableFreeTier = mapped
    }

    /**
     * @param value Enables the account to write in multiple locations
     */
    @JvmName("wntyxpqguerpvtjk")
    public suspend fun enableMultipleWriteLocations(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableMultipleWriteLocations = mapped
    }

    /**
     * @param value Flag to indicate enabling/disabling of Partition Merge feature on the account
     */
    @JvmName("gbgwoejpelsyrjrt")
    public suspend fun enablePartitionMerge(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enablePartitionMerge = mapped
    }

    /**
     * @param value Identity for the resource.
     */
    @JvmName("vcwmfxstkuogtsjl")
    public suspend fun identity(`value`: ManagedServiceIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Identity for the resource.
     */
    @JvmName("hipiqikrtfvwlcev")
    public suspend fun identity(argument: suspend ManagedServiceIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedServiceIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value List of IpRules.
     */
    @JvmName("xtybnydnlgcbhohk")
    public suspend fun ipRules(`value`: List<IpAddressOrRangeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipRules = mapped
    }

    /**
     * @param argument List of IpRules.
     */
    @JvmName("gnbdkayvvltwumcb")
    public suspend fun ipRules(argument: List<suspend IpAddressOrRangeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            IpAddressOrRangeArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ipRules = mapped
    }

    /**
     * @param argument List of IpRules.
     */
    @JvmName("peynrrilahrysydi")
    public suspend fun ipRules(vararg argument: suspend IpAddressOrRangeArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            IpAddressOrRangeArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ipRules = mapped
    }

    /**
     * @param argument List of IpRules.
     */
    @JvmName("gbyyuuasktnvbmod")
    public suspend fun ipRules(argument: suspend IpAddressOrRangeArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(IpAddressOrRangeArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ipRules = mapped
    }

    /**
     * @param values List of IpRules.
     */
    @JvmName("vwpecdgkfqprhivt")
    public suspend fun ipRules(vararg values: IpAddressOrRangeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipRules = mapped
    }

    /**
     * @param value Flag to indicate whether to enable/disable Virtual Network ACL rules.
     */
    @JvmName("debgsfgnvxkwsjav")
    public suspend fun isVirtualNetworkFilterEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isVirtualNetworkFilterEnabled = mapped
    }

    /**
     * @param value The URI of the key vault
     */
    @JvmName("euswckoijuydjdqt")
    public suspend fun keyVaultKeyUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVaultKeyUri = mapped
    }

    /**
     * @param value Indicates the type of database account. This can only be set at database account creation.
     */
    @JvmName("wmdcxfodkbuwndpc")
    public suspend fun kind(`value`: Either<String, DatabaseAccountKind>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Indicates the type of database account. This can only be set at database account creation.
     */
    @JvmName("rodrsvoxgekqdcsf")
    public fun kind(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DatabaseAccountKind>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Indicates the type of database account. This can only be set at database account creation.
     */
    @JvmName("iikpushgyuwiquee")
    public fun kind(`value`: DatabaseAccountKind) {
        val toBeMapped = Either.ofRight<String, DatabaseAccountKind>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The location of the resource group to which the resource belongs.
     */
    @JvmName("indsgvpxfgobhvwl")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value An array that contains the georeplication locations enabled for the Cosmos DB account.
     */
    @JvmName("xkekgrhvmsxjvtsq")
    public suspend fun locations(`value`: List<LocationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.locations = mapped
    }

    /**
     * @param argument An array that contains the georeplication locations enabled for the Cosmos DB account.
     */
    @JvmName("giqlowcaysycovmx")
    public suspend fun locations(argument: List<suspend LocationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { LocationArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.locations = mapped
    }

    /**
     * @param argument An array that contains the georeplication locations enabled for the Cosmos DB account.
     */
    @JvmName("ssfgfrtukusrgjah")
    public suspend fun locations(vararg argument: suspend LocationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { LocationArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.locations = mapped
    }

    /**
     * @param argument An array that contains the georeplication locations enabled for the Cosmos DB account.
     */
    @JvmName("srjsopaswfwqknmu")
    public suspend fun locations(argument: suspend LocationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(LocationArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.locations = mapped
    }

    /**
     * @param values An array that contains the georeplication locations enabled for the Cosmos DB account.
     */
    @JvmName("yxcvjglkhutmfitg")
    public suspend fun locations(vararg values: LocationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.locations = mapped
    }

    /**
     * @param value Indicates the minimum allowed Tls version. The default value is Tls 1.2. Cassandra and Mongo APIs only work with Tls 1.2.
     */
    @JvmName("ofmsmnsmrjqibwsk")
    public suspend fun minimalTlsVersion(`value`: Either<String, MinimalTlsVersion>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minimalTlsVersion = mapped
    }

    /**
     * @param value Indicates the minimum allowed Tls version. The default value is Tls 1.2. Cassandra and Mongo APIs only work with Tls 1.2.
     */
    @JvmName("wagjbljgjqokfafw")
    public fun minimalTlsVersion(`value`: String) {
        val toBeMapped = Either.ofLeft<String, MinimalTlsVersion>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.minimalTlsVersion = mapped
    }

    /**
     * @param value Indicates the minimum allowed Tls version. The default value is Tls 1.2. Cassandra and Mongo APIs only work with Tls 1.2.
     */
    @JvmName("hcrfvpsiimwquvny")
    public fun minimalTlsVersion(`value`: MinimalTlsVersion) {
        val toBeMapped = Either.ofRight<String, MinimalTlsVersion>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.minimalTlsVersion = mapped
    }

    /**
     * @param value Indicates what services are allowed to bypass firewall checks.
     */
    @JvmName("ldynklcrjdlhjyyu")
    public suspend fun networkAclBypass(`value`: NetworkAclBypass?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkAclBypass = mapped
    }

    /**
     * @param value An array that contains the Resource Ids for Network Acl Bypass for the Cosmos DB account.
     */
    @JvmName("bhaqtqisvmgocbsy")
    public suspend fun networkAclBypassResourceIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkAclBypassResourceIds = mapped
    }

    /**
     * @param values An array that contains the Resource Ids for Network Acl Bypass for the Cosmos DB account.
     */
    @JvmName("dxaobtpunrnykurf")
    public suspend fun networkAclBypassResourceIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkAclBypassResourceIds = mapped
    }

    /**
     * @param value Whether requests from Public Network are allowed
     */
    @JvmName("wnoaohvukdhpqjwj")
    public suspend fun publicNetworkAccess(`value`: Either<String, PublicNetworkAccess>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Whether requests from Public Network are allowed
     */
    @JvmName("lallhfsrjgsfekmo")
    public fun publicNetworkAccess(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PublicNetworkAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Whether requests from Public Network are allowed
     */
    @JvmName("lrkqxfkiroufbdra")
    public fun publicNetworkAccess(`value`: PublicNetworkAccess) {
        val toBeMapped = Either.ofRight<String, PublicNetworkAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ltdubovpmtroiphl")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Parameters to indicate the information about the restore.
     */
    @JvmName("sadxeebsgdyxdwrf")
    public suspend fun restoreParameters(`value`: RestoreParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restoreParameters = mapped
    }

    /**
     * @param argument Parameters to indicate the information about the restore.
     */
    @JvmName("wupdfgxksjueyhmj")
    public suspend fun restoreParameters(argument: suspend RestoreParametersArgsBuilder.() -> Unit) {
        val toBeMapped = RestoreParametersArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.restoreParameters = mapped
    }

    /**
     * @param value Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example, the default experience for a template type is set with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
     */
    @JvmName("aeymbybgbexsbger")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example, the default experience for a template type is set with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
     */
    @JvmName("hnixsnsyhxnispry")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value List of Virtual Network ACL rules configured for the Cosmos DB account.
     */
    @JvmName("aillrjtbhejcuxue")
    public suspend fun virtualNetworkRules(`value`: List<VirtualNetworkRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualNetworkRules = mapped
    }

    /**
     * @param argument List of Virtual Network ACL rules configured for the Cosmos DB account.
     */
    @JvmName("rulhxkibljvfmspv")
    public suspend fun virtualNetworkRules(argument: List<suspend VirtualNetworkRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VirtualNetworkRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.virtualNetworkRules = mapped
    }

    /**
     * @param argument List of Virtual Network ACL rules configured for the Cosmos DB account.
     */
    @JvmName("mwgsnhjvapyovxfd")
    public suspend fun virtualNetworkRules(vararg argument: suspend VirtualNetworkRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            VirtualNetworkRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.virtualNetworkRules = mapped
    }

    /**
     * @param argument List of Virtual Network ACL rules configured for the Cosmos DB account.
     */
    @JvmName("ssjeicaainpvhdqo")
    public suspend fun virtualNetworkRules(argument: suspend VirtualNetworkRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(VirtualNetworkRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.virtualNetworkRules = mapped
    }

    /**
     * @param values List of Virtual Network ACL rules configured for the Cosmos DB account.
     */
    @JvmName("pbkostefxieiaxil")
    public suspend fun virtualNetworkRules(vararg values: VirtualNetworkRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.virtualNetworkRules = mapped
    }

    internal fun build(): DatabaseAccountArgs = DatabaseAccountArgs(
        accountName = accountName,
        analyticalStorageConfiguration = analyticalStorageConfiguration,
        apiProperties = apiProperties,
        backupPolicy = backupPolicy,
        capabilities = capabilities,
        capacity = capacity,
        connectorOffer = connectorOffer,
        consistencyPolicy = consistencyPolicy,
        cors = cors,
        createMode = createMode,
        databaseAccountOfferType = databaseAccountOfferType,
        defaultIdentity = defaultIdentity,
        disableKeyBasedMetadataWriteAccess = disableKeyBasedMetadataWriteAccess,
        disableLocalAuth = disableLocalAuth,
        enableAnalyticalStorage = enableAnalyticalStorage,
        enableAutomaticFailover = enableAutomaticFailover,
        enableCassandraConnector = enableCassandraConnector,
        enableFreeTier = enableFreeTier,
        enableMultipleWriteLocations = enableMultipleWriteLocations,
        enablePartitionMerge = enablePartitionMerge,
        identity = identity,
        ipRules = ipRules,
        isVirtualNetworkFilterEnabled = isVirtualNetworkFilterEnabled,
        keyVaultKeyUri = keyVaultKeyUri,
        kind = kind,
        location = location,
        locations = locations,
        minimalTlsVersion = minimalTlsVersion,
        networkAclBypass = networkAclBypass,
        networkAclBypassResourceIds = networkAclBypassResourceIds,
        publicNetworkAccess = publicNetworkAccess,
        resourceGroupName = resourceGroupName,
        restoreParameters = restoreParameters,
        tags = tags,
        virtualNetworkRules = virtualNetworkRules,
    )
}
