@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin

import com.pulumi.azurenative.documentdb.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.documentdb.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [FirewallRule].
 */
@PulumiTagMarker
public class FirewallRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FirewallRuleArgs = FirewallRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FirewallRuleArgsBuilder.() -> Unit) {
        val builder = FirewallRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): FirewallRule {
        val builtJavaResource = com.pulumi.azurenative.documentdb.FirewallRule(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return FirewallRule(builtJavaResource)
    }
}

/**
 * Represents a mongo cluster firewall rule.
 * Azure REST API version: 2024-03-01-preview.
 * ## Example Usage
 * ### Creates a firewall rule on a Mongo Cluster resource.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var firewallRule = new AzureNative.DocumentDB.FirewallRule("firewallRule", new()
 *     {
 *         EndIpAddress = "255.255.255.255",
 *         FirewallRuleName = "rule1",
 *         MongoClusterName = "myMongoCluster",
 *         ResourceGroupName = "TestGroup",
 *         StartIpAddress = "0.0.0.0",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/documentdb/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := documentdb.NewFirewallRule(ctx, "firewallRule", &documentdb.FirewallRuleArgs{
 * 			EndIpAddress:      pulumi.String("255.255.255.255"),
 * 			FirewallRuleName:  pulumi.String("rule1"),
 * 			MongoClusterName:  pulumi.String("myMongoCluster"),
 * 			ResourceGroupName: pulumi.String("TestGroup"),
 * 			StartIpAddress:    pulumi.String("0.0.0.0"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.documentdb.FirewallRule;
 * import com.pulumi.azurenative.documentdb.FirewallRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var firewallRule = new FirewallRule("firewallRule", FirewallRuleArgs.builder()
 *             .endIpAddress("255.255.255.255")
 *             .firewallRuleName("rule1")
 *             .mongoClusterName("myMongoCluster")
 *             .resourceGroupName("TestGroup")
 *             .startIpAddress("0.0.0.0")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:documentdb:FirewallRule rule1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/mongoClusters/{mongoClusterName}/firewallRules/{firewallRuleName}
 * ```
 */
public class FirewallRule internal constructor(
    override val javaResource: com.pulumi.azurenative.documentdb.FirewallRule,
) : KotlinCustomResource(javaResource, FirewallRuleMapper) {
    /**
     * The end IP address of the mongo cluster firewall rule. Must be IPv4 format.
     */
    public val endIpAddress: Output<String>
        get() = javaResource.endIpAddress().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the firewall rule.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The start IP address of the mongo cluster firewall rule. Must be IPv4 format.
     */
    public val startIpAddress: Output<String>
        get() = javaResource.startIpAddress().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object FirewallRuleMapper : ResourceMapper<FirewallRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.documentdb.FirewallRule::class == javaResource::class

    override fun map(javaResource: Resource): FirewallRule = FirewallRule(
        javaResource as
            com.pulumi.azurenative.documentdb.FirewallRule,
    )
}

/**
 * @see [FirewallRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [FirewallRule].
 */
public suspend fun firewallRule(
    name: String,
    block: suspend FirewallRuleResourceBuilder.() -> Unit,
): FirewallRule {
    val builder = FirewallRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [FirewallRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun firewallRule(name: String): FirewallRule {
    val builder = FirewallRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
