@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin

import com.pulumi.azurenative.documentdb.FirewallRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Represents a mongo cluster firewall rule.
 * Azure REST API version: 2024-03-01-preview.
 * ## Example Usage
 * ### Creates a firewall rule on a Mongo Cluster resource.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var firewallRule = new AzureNative.DocumentDB.FirewallRule("firewallRule", new()
 *     {
 *         EndIpAddress = "255.255.255.255",
 *         FirewallRuleName = "rule1",
 *         MongoClusterName = "myMongoCluster",
 *         ResourceGroupName = "TestGroup",
 *         StartIpAddress = "0.0.0.0",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/documentdb/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := documentdb.NewFirewallRule(ctx, "firewallRule", &documentdb.FirewallRuleArgs{
 * 			EndIpAddress:      pulumi.String("255.255.255.255"),
 * 			FirewallRuleName:  pulumi.String("rule1"),
 * 			MongoClusterName:  pulumi.String("myMongoCluster"),
 * 			ResourceGroupName: pulumi.String("TestGroup"),
 * 			StartIpAddress:    pulumi.String("0.0.0.0"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.documentdb.FirewallRule;
 * import com.pulumi.azurenative.documentdb.FirewallRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var firewallRule = new FirewallRule("firewallRule", FirewallRuleArgs.builder()
 *             .endIpAddress("255.255.255.255")
 *             .firewallRuleName("rule1")
 *             .mongoClusterName("myMongoCluster")
 *             .resourceGroupName("TestGroup")
 *             .startIpAddress("0.0.0.0")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:documentdb:FirewallRule rule1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/mongoClusters/{mongoClusterName}/firewallRules/{firewallRuleName}
 * ```
 * @property endIpAddress The end IP address of the mongo cluster firewall rule. Must be IPv4 format.
 * @property firewallRuleName The name of the mongo cluster firewall rule.
 * @property mongoClusterName The name of the mongo cluster.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property startIpAddress The start IP address of the mongo cluster firewall rule. Must be IPv4 format.
 */
public data class FirewallRuleArgs(
    public val endIpAddress: Output<String>? = null,
    public val firewallRuleName: Output<String>? = null,
    public val mongoClusterName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val startIpAddress: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.FirewallRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.FirewallRuleArgs =
        com.pulumi.azurenative.documentdb.FirewallRuleArgs.builder()
            .endIpAddress(endIpAddress?.applyValue({ args0 -> args0 }))
            .firewallRuleName(firewallRuleName?.applyValue({ args0 -> args0 }))
            .mongoClusterName(mongoClusterName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .startIpAddress(startIpAddress?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FirewallRuleArgs].
 */
@PulumiTagMarker
public class FirewallRuleArgsBuilder internal constructor() {
    private var endIpAddress: Output<String>? = null

    private var firewallRuleName: Output<String>? = null

    private var mongoClusterName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var startIpAddress: Output<String>? = null

    /**
     * @param value The end IP address of the mongo cluster firewall rule. Must be IPv4 format.
     */
    @JvmName("aelvmchtyahsfhbu")
    public suspend fun endIpAddress(`value`: Output<String>) {
        this.endIpAddress = value
    }

    /**
     * @param value The name of the mongo cluster firewall rule.
     */
    @JvmName("ducvbbsywvohkxww")
    public suspend fun firewallRuleName(`value`: Output<String>) {
        this.firewallRuleName = value
    }

    /**
     * @param value The name of the mongo cluster.
     */
    @JvmName("htqvltmpgwfmphbf")
    public suspend fun mongoClusterName(`value`: Output<String>) {
        this.mongoClusterName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("xqfnlgqryyahvjss")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The start IP address of the mongo cluster firewall rule. Must be IPv4 format.
     */
    @JvmName("ddeaffxeetfayafg")
    public suspend fun startIpAddress(`value`: Output<String>) {
        this.startIpAddress = value
    }

    /**
     * @param value The end IP address of the mongo cluster firewall rule. Must be IPv4 format.
     */
    @JvmName("pnqewunpgsoywaie")
    public suspend fun endIpAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endIpAddress = mapped
    }

    /**
     * @param value The name of the mongo cluster firewall rule.
     */
    @JvmName("pgkycubwrjmpwics")
    public suspend fun firewallRuleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firewallRuleName = mapped
    }

    /**
     * @param value The name of the mongo cluster.
     */
    @JvmName("jkjpgmvtllhsyyhr")
    public suspend fun mongoClusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mongoClusterName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ilpeuudhexgwfnxl")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The start IP address of the mongo cluster firewall rule. Must be IPv4 format.
     */
    @JvmName("bwqbxcqkvhkenljw")
    public suspend fun startIpAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startIpAddress = mapped
    }

    internal fun build(): FirewallRuleArgs = FirewallRuleArgs(
        endIpAddress = endIpAddress,
        firewallRuleName = firewallRuleName,
        mongoClusterName = mongoClusterName,
        resourceGroupName = resourceGroupName,
        startIpAddress = startIpAddress,
    )
}
