@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin

import com.pulumi.azurenative.documentdb.MongoClusterArgs.builder
import com.pulumi.azurenative.documentdb.kotlin.enums.CreateMode
import com.pulumi.azurenative.documentdb.kotlin.inputs.MongoClusterRestoreParametersArgs
import com.pulumi.azurenative.documentdb.kotlin.inputs.MongoClusterRestoreParametersArgsBuilder
import com.pulumi.azurenative.documentdb.kotlin.inputs.NodeGroupSpecArgs
import com.pulumi.azurenative.documentdb.kotlin.inputs.NodeGroupSpecArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Represents a mongo cluster resource.
 * Azure REST API version: 2023-03-15-preview.
 * Other available API versions: 2023-09-15-preview, 2023-11-15-preview, 2024-02-15-preview, 2024-03-01-preview.
 * ## Example Usage
 * ### Create a new mongo cluster
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var mongoCluster = new AzureNative.DocumentDB.MongoCluster("mongoCluster", new()
 *     {
 *         AdministratorLogin = "mongoAdmin",
 *         AdministratorLoginPassword = "password",
 *         Location = "westus2",
 *         MongoClusterName = "myMongoCluster",
 *         NodeGroupSpecs = new[]
 *         {
 *             new AzureNative.DocumentDB.Inputs.NodeGroupSpecArgs
 *             {
 *                 DiskSizeGB = 128,
 *                 EnableHa = true,
 *                 Kind = AzureNative.DocumentDB.NodeKind.Shard,
 *                 NodeCount = 3,
 *                 Sku = "M30",
 *             },
 *         },
 *         ResourceGroupName = "TestResourceGroup",
 *         ServerVersion = "5.0",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/documentdb/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := documentdb.NewMongoCluster(ctx, "mongoCluster", &documentdb.MongoClusterArgs{
 * 			AdministratorLogin:         pulumi.String("mongoAdmin"),
 * 			AdministratorLoginPassword: pulumi.String("password"),
 * 			Location:                   pulumi.String("westus2"),
 * 			MongoClusterName:           pulumi.String("myMongoCluster"),
 * 			NodeGroupSpecs: documentdb.NodeGroupSpecArray{
 * 				&documentdb.NodeGroupSpecArgs{
 * 					DiskSizeGB: pulumi.Float64(128),
 * 					EnableHa:   pulumi.Bool(true),
 * 					Kind:       pulumi.String(documentdb.NodeKindShard),
 * 					NodeCount:  pulumi.Int(3),
 * 					Sku:        pulumi.String("M30"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("TestResourceGroup"),
 * 			ServerVersion:     pulumi.String("5.0"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.documentdb.MongoCluster;
 * import com.pulumi.azurenative.documentdb.MongoClusterArgs;
 * import com.pulumi.azurenative.documentdb.inputs.NodeGroupSpecArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var mongoCluster = new MongoCluster("mongoCluster", MongoClusterArgs.builder()
 *             .administratorLogin("mongoAdmin")
 *             .administratorLoginPassword("password")
 *             .location("westus2")
 *             .mongoClusterName("myMongoCluster")
 *             .nodeGroupSpecs(NodeGroupSpecArgs.builder()
 *                 .diskSizeGB(128)
 *                 .enableHa(true)
 *                 .kind("Shard")
 *                 .nodeCount(3)
 *                 .sku("M30")
 *                 .build())
 *             .resourceGroupName("TestResourceGroup")
 *             .serverVersion("5.0")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a new mongo cluster with point in time restore
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var mongoCluster = new AzureNative.DocumentDB.MongoCluster("mongoCluster", new()
 *     {
 *         CreateMode = AzureNative.DocumentDB.CreateMode.PointInTimeRestore,
 *         Location = "westus2",
 *         MongoClusterName = "myMongoCluster",
 *         ResourceGroupName = "TestResourceGroup",
 *         RestoreParameters = new AzureNative.DocumentDB.Inputs.MongoClusterRestoreParametersArgs
 *         {
 *             PointInTimeUTC = "2023-01-13T20:07:35Z",
 *             SourceResourceId = "/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestResourceGroup/providers/Microsoft.DocumentDB/mongoClusters/myOtherMongoCluster",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/documentdb/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := documentdb.NewMongoCluster(ctx, "mongoCluster", &documentdb.MongoClusterArgs{
 * 			CreateMode:        pulumi.String(documentdb.CreateModePointInTimeRestore),
 * 			Location:          pulumi.String("westus2"),
 * 			MongoClusterName:  pulumi.String("myMongoCluster"),
 * 			ResourceGroupName: pulumi.String("TestResourceGroup"),
 * 			RestoreParameters: &documentdb.MongoClusterRestoreParametersArgs{
 * 				PointInTimeUTC:   pulumi.String("2023-01-13T20:07:35Z"),
 * 				SourceResourceId: pulumi.String("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestResourceGroup/providers/Microsoft.DocumentDB/mongoClusters/myOtherMongoCluster"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.documentdb.MongoCluster;
 * import com.pulumi.azurenative.documentdb.MongoClusterArgs;
 * import com.pulumi.azurenative.documentdb.inputs.MongoClusterRestoreParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var mongoCluster = new MongoCluster("mongoCluster", MongoClusterArgs.builder()
 *             .createMode("PointInTimeRestore")
 *             .location("westus2")
 *             .mongoClusterName("myMongoCluster")
 *             .resourceGroupName("TestResourceGroup")
 *             .restoreParameters(MongoClusterRestoreParametersArgs.builder()
 *                 .pointInTimeUTC("2023-01-13T20:07:35Z")
 *                 .sourceResourceId("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestResourceGroup/providers/Microsoft.DocumentDB/mongoClusters/myOtherMongoCluster")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:documentdb:MongoCluster myMongoCluster /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/mongoClusters/{mongoClusterName}
 * ```
 * @property administratorLogin The administrator's login for the mongo cluster.
 * @property administratorLoginPassword The password of the administrator login.
 * @property createMode The mode to create a mongo cluster.
 * @property location The geo-location where the resource lives
 * @property mongoClusterName The name of the mongo cluster.
 * @property nodeGroupSpecs The list of node group specs in the cluster.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property restoreParameters Parameters used for restore operations
 * @property serverVersion The Mongo DB server version. Defaults to the latest available version if not specified.
 * @property tags Resource tags.
 */
public data class MongoClusterArgs(
    public val administratorLogin: Output<String>? = null,
    public val administratorLoginPassword: Output<String>? = null,
    public val createMode: Output<Either<String, CreateMode>>? = null,
    public val location: Output<String>? = null,
    public val mongoClusterName: Output<String>? = null,
    public val nodeGroupSpecs: Output<List<NodeGroupSpecArgs>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val restoreParameters: Output<MongoClusterRestoreParametersArgs>? = null,
    public val serverVersion: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.MongoClusterArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.MongoClusterArgs =
        com.pulumi.azurenative.documentdb.MongoClusterArgs.builder()
            .administratorLogin(administratorLogin?.applyValue({ args0 -> args0 }))
            .administratorLoginPassword(administratorLoginPassword?.applyValue({ args0 -> args0 }))
            .createMode(
                createMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .mongoClusterName(mongoClusterName?.applyValue({ args0 -> args0 }))
            .nodeGroupSpecs(
                nodeGroupSpecs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .restoreParameters(restoreParameters?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .serverVersion(serverVersion?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [MongoClusterArgs].
 */
@PulumiTagMarker
public class MongoClusterArgsBuilder internal constructor() {
    private var administratorLogin: Output<String>? = null

    private var administratorLoginPassword: Output<String>? = null

    private var createMode: Output<Either<String, CreateMode>>? = null

    private var location: Output<String>? = null

    private var mongoClusterName: Output<String>? = null

    private var nodeGroupSpecs: Output<List<NodeGroupSpecArgs>>? = null

    private var resourceGroupName: Output<String>? = null

    private var restoreParameters: Output<MongoClusterRestoreParametersArgs>? = null

    private var serverVersion: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The administrator's login for the mongo cluster.
     */
    @JvmName("plbkwkqkbuxcpapq")
    public suspend fun administratorLogin(`value`: Output<String>) {
        this.administratorLogin = value
    }

    /**
     * @param value The password of the administrator login.
     */
    @JvmName("ghktdkdeqevucbxx")
    public suspend fun administratorLoginPassword(`value`: Output<String>) {
        this.administratorLoginPassword = value
    }

    /**
     * @param value The mode to create a mongo cluster.
     */
    @JvmName("oqlcojhpuihdxudf")
    public suspend fun createMode(`value`: Output<Either<String, CreateMode>>) {
        this.createMode = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("wqancmxuiuptagyg")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the mongo cluster.
     */
    @JvmName("jwcykcrihdnmlyyh")
    public suspend fun mongoClusterName(`value`: Output<String>) {
        this.mongoClusterName = value
    }

    /**
     * @param value The list of node group specs in the cluster.
     */
    @JvmName("xggdrvpdugqrbvoo")
    public suspend fun nodeGroupSpecs(`value`: Output<List<NodeGroupSpecArgs>>) {
        this.nodeGroupSpecs = value
    }

    @JvmName("njjhhyvecuauvsvw")
    public suspend fun nodeGroupSpecs(vararg values: Output<NodeGroupSpecArgs>) {
        this.nodeGroupSpecs = Output.all(values.asList())
    }

    /**
     * @param values The list of node group specs in the cluster.
     */
    @JvmName("fqnctthiyvwaxtmb")
    public suspend fun nodeGroupSpecs(values: List<Output<NodeGroupSpecArgs>>) {
        this.nodeGroupSpecs = Output.all(values)
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ewthlhpeluhqqsxl")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Parameters used for restore operations
     */
    @JvmName("ofykfsvktrgvwawn")
    public suspend fun restoreParameters(`value`: Output<MongoClusterRestoreParametersArgs>) {
        this.restoreParameters = value
    }

    /**
     * @param value The Mongo DB server version. Defaults to the latest available version if not specified.
     */
    @JvmName("lnuirwnpktrpnyre")
    public suspend fun serverVersion(`value`: Output<String>) {
        this.serverVersion = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("qydrmwnlydhmcumq")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The administrator's login for the mongo cluster.
     */
    @JvmName("kjwlejnrjbdimcjc")
    public suspend fun administratorLogin(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.administratorLogin = mapped
    }

    /**
     * @param value The password of the administrator login.
     */
    @JvmName("djcbtiioomevfetf")
    public suspend fun administratorLoginPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.administratorLoginPassword = mapped
    }

    /**
     * @param value The mode to create a mongo cluster.
     */
    @JvmName("qmwoohwrjqfhjypu")
    public suspend fun createMode(`value`: Either<String, CreateMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.createMode = mapped
    }

    /**
     * @param value The mode to create a mongo cluster.
     */
    @JvmName("vyxhilhddoanxxwb")
    public fun createMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, CreateMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.createMode = mapped
    }

    /**
     * @param value The mode to create a mongo cluster.
     */
    @JvmName("rdidqmrqbsvljyqu")
    public fun createMode(`value`: CreateMode) {
        val toBeMapped = Either.ofRight<String, CreateMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.createMode = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("rmfmillmipmyglqv")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the mongo cluster.
     */
    @JvmName("kerxqkhmoqigsxol")
    public suspend fun mongoClusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mongoClusterName = mapped
    }

    /**
     * @param value The list of node group specs in the cluster.
     */
    @JvmName("vunwylqyjpyhyulx")
    public suspend fun nodeGroupSpecs(`value`: List<NodeGroupSpecArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeGroupSpecs = mapped
    }

    /**
     * @param argument The list of node group specs in the cluster.
     */
    @JvmName("mjkkfmfrulkmqqyk")
    public suspend fun nodeGroupSpecs(argument: List<suspend NodeGroupSpecArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            NodeGroupSpecArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.nodeGroupSpecs = mapped
    }

    /**
     * @param argument The list of node group specs in the cluster.
     */
    @JvmName("ocdyfmgfgbljlufu")
    public suspend fun nodeGroupSpecs(vararg argument: suspend NodeGroupSpecArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            NodeGroupSpecArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.nodeGroupSpecs = mapped
    }

    /**
     * @param argument The list of node group specs in the cluster.
     */
    @JvmName("jbsuwjrpyxlfjwor")
    public suspend fun nodeGroupSpecs(argument: suspend NodeGroupSpecArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(NodeGroupSpecArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.nodeGroupSpecs = mapped
    }

    /**
     * @param values The list of node group specs in the cluster.
     */
    @JvmName("qxwomsrquvmbavuh")
    public suspend fun nodeGroupSpecs(vararg values: NodeGroupSpecArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nodeGroupSpecs = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("isaurmuqncvuypyk")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Parameters used for restore operations
     */
    @JvmName("rjnnhpmodqkxftee")
    public suspend fun restoreParameters(`value`: MongoClusterRestoreParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restoreParameters = mapped
    }

    /**
     * @param argument Parameters used for restore operations
     */
    @JvmName("ifrnqyouwlbfoosw")
    public suspend fun restoreParameters(argument: suspend MongoClusterRestoreParametersArgsBuilder.() -> Unit) {
        val toBeMapped = MongoClusterRestoreParametersArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.restoreParameters = mapped
    }

    /**
     * @param value The Mongo DB server version. Defaults to the latest available version if not specified.
     */
    @JvmName("jhhparwgmxxkalok")
    public suspend fun serverVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverVersion = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("hmvmoirxcknoikfe")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("nrhehtcufxtikpmv")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): MongoClusterArgs = MongoClusterArgs(
        administratorLogin = administratorLogin,
        administratorLoginPassword = administratorLoginPassword,
        createMode = createMode,
        location = location,
        mongoClusterName = mongoClusterName,
        nodeGroupSpecs = nodeGroupSpecs,
        resourceGroupName = resourceGroupName,
        restoreParameters = restoreParameters,
        serverVersion = serverVersion,
        tags = tags,
    )
}
