@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin

import com.pulumi.azurenative.documentdb.NotebookWorkspaceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A notebook workspace resource
 * Azure REST API version: 2023-04-15. Prior API version in Azure Native 1.x: 2021-03-15.
 * Other available API versions: 2023-09-15, 2023-09-15-preview, 2023-11-15, 2023-11-15-preview, 2024-02-15-preview, 2024-05-15, 2024-05-15-preview.
 * ## Example Usage
 * ### CosmosDBNotebookWorkspaceCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var notebookWorkspace = new AzureNative.DocumentDB.NotebookWorkspace("notebookWorkspace", new()
 *     {
 *         AccountName = "ddb1",
 *         NotebookWorkspaceName = "default",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/documentdb/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := documentdb.NewNotebookWorkspace(ctx, "notebookWorkspace", &documentdb.NotebookWorkspaceArgs{
 * 			AccountName:           pulumi.String("ddb1"),
 * 			NotebookWorkspaceName: pulumi.String("default"),
 * 			ResourceGroupName:     pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.documentdb.NotebookWorkspace;
 * import com.pulumi.azurenative.documentdb.NotebookWorkspaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var notebookWorkspace = new NotebookWorkspace("notebookWorkspace", NotebookWorkspaceArgs.builder()
 *             .accountName("ddb1")
 *             .notebookWorkspaceName("default")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:documentdb:NotebookWorkspace default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/notebookWorkspaces/{notebookWorkspaceName}
 * ```
 * @property accountName Cosmos DB database account name.
 * @property notebookWorkspaceName The name of the notebook workspace resource.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class NotebookWorkspaceArgs(
    public val accountName: Output<String>? = null,
    public val notebookWorkspaceName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.NotebookWorkspaceArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.NotebookWorkspaceArgs =
        com.pulumi.azurenative.documentdb.NotebookWorkspaceArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .notebookWorkspaceName(notebookWorkspaceName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NotebookWorkspaceArgs].
 */
@PulumiTagMarker
public class NotebookWorkspaceArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var notebookWorkspaceName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value Cosmos DB database account name.
     */
    @JvmName("ifrpymxptewrkqnu")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value The name of the notebook workspace resource.
     */
    @JvmName("ltorndujhbcmtqbh")
    public suspend fun notebookWorkspaceName(`value`: Output<String>) {
        this.notebookWorkspaceName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ksspbdpjqwowgqky")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Cosmos DB database account name.
     */
    @JvmName("nkralmtpsncenlrv")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value The name of the notebook workspace resource.
     */
    @JvmName("kmdyvqtipagwtgxr")
    public suspend fun notebookWorkspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notebookWorkspaceName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("wimhjhwopllgnpdi")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): NotebookWorkspaceArgs = NotebookWorkspaceArgs(
        accountName = accountName,
        notebookWorkspaceName = notebookWorkspaceName,
        resourceGroupName = resourceGroupName,
    )
}
