@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin

import com.pulumi.azurenative.documentdb.PrivateEndpointConnectionArgs.builder
import com.pulumi.azurenative.documentdb.kotlin.inputs.PrivateEndpointPropertyArgs
import com.pulumi.azurenative.documentdb.kotlin.inputs.PrivateEndpointPropertyArgsBuilder
import com.pulumi.azurenative.documentdb.kotlin.inputs.PrivateLinkServiceConnectionStatePropertyArgs
import com.pulumi.azurenative.documentdb.kotlin.inputs.PrivateLinkServiceConnectionStatePropertyArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * A private endpoint connection
 * Azure REST API version: 2023-04-15. Prior API version in Azure Native 1.x: 2021-03-15.
 * Other available API versions: 2023-09-15, 2023-09-15-preview, 2023-11-15, 2023-11-15-preview, 2024-02-15-preview, 2024-03-01-preview, 2024-05-15, 2024-05-15-preview.
 * ## Example Usage
 * ### Approve or reject a private endpoint connection with a given name.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateEndpointConnection = new AzureNative.DocumentDB.PrivateEndpointConnection("privateEndpointConnection", new()
 *     {
 *         AccountName = "ddb1",
 *         PrivateEndpointConnectionName = "privateEndpointConnectionName",
 *         PrivateLinkServiceConnectionState = new AzureNative.DocumentDB.Inputs.PrivateLinkServiceConnectionStatePropertyArgs
 *         {
 *             Description = "Approved by johndoe@contoso.com",
 *             Status = "Approved",
 *         },
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/documentdb/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := documentdb.NewPrivateEndpointConnection(ctx, "privateEndpointConnection", &documentdb.PrivateEndpointConnectionArgs{
 * 			AccountName:                   pulumi.String("ddb1"),
 * 			PrivateEndpointConnectionName: pulumi.String("privateEndpointConnectionName"),
 * 			PrivateLinkServiceConnectionState: &documentdb.PrivateLinkServiceConnectionStatePropertyArgs{
 * 				Description: pulumi.String("Approved by johndoe@contoso.com"),
 * 				Status:      pulumi.String("Approved"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.documentdb.PrivateEndpointConnection;
 * import com.pulumi.azurenative.documentdb.PrivateEndpointConnectionArgs;
 * import com.pulumi.azurenative.documentdb.inputs.PrivateLinkServiceConnectionStatePropertyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateEndpointConnection = new PrivateEndpointConnection("privateEndpointConnection", PrivateEndpointConnectionArgs.builder()
 *             .accountName("ddb1")
 *             .privateEndpointConnectionName("privateEndpointConnectionName")
 *             .privateLinkServiceConnectionState(PrivateLinkServiceConnectionStatePropertyArgs.builder()
 *                 .description("Approved by johndoe@contoso.com")
 *                 .status("Approved")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:documentdb:PrivateEndpointConnection privateEndpointConnectionName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/privateEndpointConnections/{privateEndpointConnectionName}
 * ```
 * @property accountName Cosmos DB database account name.
 * @property groupId Group id of the private endpoint.
 * @property privateEndpoint Private endpoint which the connection belongs to.
 * @property privateEndpointConnectionName The name of the private endpoint connection.
 * @property privateLinkServiceConnectionState Connection State of the Private Endpoint Connection.
 * @property provisioningState Provisioning state of the private endpoint.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class PrivateEndpointConnectionArgs(
    public val accountName: Output<String>? = null,
    public val groupId: Output<String>? = null,
    public val privateEndpoint: Output<PrivateEndpointPropertyArgs>? = null,
    public val privateEndpointConnectionName: Output<String>? = null,
    public val privateLinkServiceConnectionState: Output<PrivateLinkServiceConnectionStatePropertyArgs>? = null,
    public val provisioningState: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.PrivateEndpointConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.PrivateEndpointConnectionArgs =
        com.pulumi.azurenative.documentdb.PrivateEndpointConnectionArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .groupId(groupId?.applyValue({ args0 -> args0 }))
            .privateEndpoint(privateEndpoint?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .privateEndpointConnectionName(privateEndpointConnectionName?.applyValue({ args0 -> args0 }))
            .privateLinkServiceConnectionState(
                privateLinkServiceConnectionState?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .provisioningState(provisioningState?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PrivateEndpointConnectionArgs].
 */
@PulumiTagMarker
public class PrivateEndpointConnectionArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var groupId: Output<String>? = null

    private var privateEndpoint: Output<PrivateEndpointPropertyArgs>? = null

    private var privateEndpointConnectionName: Output<String>? = null

    private var privateLinkServiceConnectionState:
        Output<PrivateLinkServiceConnectionStatePropertyArgs>? = null

    private var provisioningState: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value Cosmos DB database account name.
     */
    @JvmName("wgmpffeupguqtwtg")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value Group id of the private endpoint.
     */
    @JvmName("eewbfujvyquundjs")
    public suspend fun groupId(`value`: Output<String>) {
        this.groupId = value
    }

    /**
     * @param value Private endpoint which the connection belongs to.
     */
    @JvmName("fkuxehvwbpbglijy")
    public suspend fun privateEndpoint(`value`: Output<PrivateEndpointPropertyArgs>) {
        this.privateEndpoint = value
    }

    /**
     * @param value The name of the private endpoint connection.
     */
    @JvmName("shuvguvoylfiapke")
    public suspend fun privateEndpointConnectionName(`value`: Output<String>) {
        this.privateEndpointConnectionName = value
    }

    /**
     * @param value Connection State of the Private Endpoint Connection.
     */
    @JvmName("ryjsyyrvqbnoefpf")
    public suspend fun privateLinkServiceConnectionState(`value`: Output<PrivateLinkServiceConnectionStatePropertyArgs>) {
        this.privateLinkServiceConnectionState = value
    }

    /**
     * @param value Provisioning state of the private endpoint.
     */
    @JvmName("extomoxiotiemqpx")
    public suspend fun provisioningState(`value`: Output<String>) {
        this.provisioningState = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jhnjjexykxnugcqq")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Cosmos DB database account name.
     */
    @JvmName("svrgrdoshvnqvefo")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value Group id of the private endpoint.
     */
    @JvmName("gopdrirbfvhkxvpv")
    public suspend fun groupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupId = mapped
    }

    /**
     * @param value Private endpoint which the connection belongs to.
     */
    @JvmName("mcnivwkdrppevlbo")
    public suspend fun privateEndpoint(`value`: PrivateEndpointPropertyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateEndpoint = mapped
    }

    /**
     * @param argument Private endpoint which the connection belongs to.
     */
    @JvmName("xgnmgjctyomyxrwp")
    public suspend fun privateEndpoint(argument: suspend PrivateEndpointPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = PrivateEndpointPropertyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.privateEndpoint = mapped
    }

    /**
     * @param value The name of the private endpoint connection.
     */
    @JvmName("vtvmugefrusxlqjb")
    public suspend fun privateEndpointConnectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateEndpointConnectionName = mapped
    }

    /**
     * @param value Connection State of the Private Endpoint Connection.
     */
    @JvmName("hxtavfioscpkwxne")
    public suspend fun privateLinkServiceConnectionState(`value`: PrivateLinkServiceConnectionStatePropertyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param argument Connection State of the Private Endpoint Connection.
     */
    @JvmName("hxcnrutqpcgcjkwh")
    public suspend fun privateLinkServiceConnectionState(argument: suspend PrivateLinkServiceConnectionStatePropertyArgsBuilder.() -> Unit) {
        val toBeMapped = PrivateLinkServiceConnectionStatePropertyArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param value Provisioning state of the private endpoint.
     */
    @JvmName("mxhgpyejorhaucyl")
    public suspend fun provisioningState(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("mhnytbsaouesexoq")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): PrivateEndpointConnectionArgs = PrivateEndpointConnectionArgs(
        accountName = accountName,
        groupId = groupId,
        privateEndpoint = privateEndpoint,
        privateEndpointConnectionName = privateEndpointConnectionName,
        privateLinkServiceConnectionState = privateLinkServiceConnectionState,
        provisioningState = provisioningState,
        resourceGroupName = resourceGroupName,
    )
}
