@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin

import com.pulumi.azurenative.documentdb.ServiceArgs.builder
import com.pulumi.azurenative.documentdb.kotlin.enums.ServiceSize
import com.pulumi.azurenative.documentdb.kotlin.enums.ServiceType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Properties for the database account.
 * Azure REST API version: 2023-04-15. Prior API version in Azure Native 1.x: 2021-04-01-preview.
 * Other available API versions: 2023-09-15, 2023-09-15-preview, 2023-11-15, 2023-11-15-preview, 2024-02-15-preview, 2024-05-15, 2024-05-15-preview.
 * ## Example Usage
 * ### DataTransferServiceCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var service = new AzureNative.DocumentDB.Service("service", new()
 *     {
 *         AccountName = "ddb1",
 *         InstanceCount = 1,
 *         InstanceSize = AzureNative.DocumentDB.ServiceSize.Cosmos_D4s,
 *         ResourceGroupName = "rg1",
 *         ServiceName = "DataTransfer",
 *         ServiceType = AzureNative.DocumentDB.ServiceType.DataTransfer,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/documentdb/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := documentdb.NewService(ctx, "service", &documentdb.ServiceArgs{
 * 			AccountName:       pulumi.String("ddb1"),
 * 			InstanceCount:     pulumi.Int(1),
 * 			InstanceSize:      pulumi.String(documentdb.ServiceSize_Cosmos_D4s),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("DataTransfer"),
 * 			ServiceType:       pulumi.String(documentdb.ServiceTypeDataTransfer),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.documentdb.Service;
 * import com.pulumi.azurenative.documentdb.ServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var service = new Service("service", ServiceArgs.builder()
 *             .accountName("ddb1")
 *             .instanceCount(1)
 *             .instanceSize("Cosmos.D4s")
 *             .resourceGroupName("rg1")
 *             .serviceName("DataTransfer")
 *             .serviceType("DataTransfer")
 *             .build());
 *     }
 * }
 * ```
 * ### GraphAPIComputeServiceCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var service = new AzureNative.DocumentDB.Service("service", new()
 *     {
 *         AccountName = "ddb1",
 *         InstanceCount = 1,
 *         InstanceSize = AzureNative.DocumentDB.ServiceSize.Cosmos_D4s,
 *         ResourceGroupName = "rg1",
 *         ServiceName = "GraphAPICompute",
 *         ServiceType = AzureNative.DocumentDB.ServiceType.GraphAPICompute,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/documentdb/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := documentdb.NewService(ctx, "service", &documentdb.ServiceArgs{
 * 			AccountName:       pulumi.String("ddb1"),
 * 			InstanceCount:     pulumi.Int(1),
 * 			InstanceSize:      pulumi.String(documentdb.ServiceSize_Cosmos_D4s),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("GraphAPICompute"),
 * 			ServiceType:       pulumi.String(documentdb.ServiceTypeGraphAPICompute),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.documentdb.Service;
 * import com.pulumi.azurenative.documentdb.ServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var service = new Service("service", ServiceArgs.builder()
 *             .accountName("ddb1")
 *             .instanceCount(1)
 *             .instanceSize("Cosmos.D4s")
 *             .resourceGroupName("rg1")
 *             .serviceName("GraphAPICompute")
 *             .serviceType("GraphAPICompute")
 *             .build());
 *     }
 * }
 * ```
 * ### MaterializedViewsBuilderServiceCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var service = new AzureNative.DocumentDB.Service("service", new()
 *     {
 *         AccountName = "ddb1",
 *         InstanceCount = 1,
 *         InstanceSize = AzureNative.DocumentDB.ServiceSize.Cosmos_D4s,
 *         ResourceGroupName = "rg1",
 *         ServiceName = "MaterializedViewsBuilder",
 *         ServiceType = AzureNative.DocumentDB.ServiceType.MaterializedViewsBuilder,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/documentdb/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := documentdb.NewService(ctx, "service", &documentdb.ServiceArgs{
 * 			AccountName:       pulumi.String("ddb1"),
 * 			InstanceCount:     pulumi.Int(1),
 * 			InstanceSize:      pulumi.String(documentdb.ServiceSize_Cosmos_D4s),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("MaterializedViewsBuilder"),
 * 			ServiceType:       pulumi.String(documentdb.ServiceTypeMaterializedViewsBuilder),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.documentdb.Service;
 * import com.pulumi.azurenative.documentdb.ServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var service = new Service("service", ServiceArgs.builder()
 *             .accountName("ddb1")
 *             .instanceCount(1)
 *             .instanceSize("Cosmos.D4s")
 *             .resourceGroupName("rg1")
 *             .serviceName("MaterializedViewsBuilder")
 *             .serviceType("MaterializedViewsBuilder")
 *             .build());
 *     }
 * }
 * ```
 * ### SqlDedicatedGatewayServiceCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var service = new AzureNative.DocumentDB.Service("service", new()
 *     {
 *         AccountName = "ddb1",
 *         InstanceCount = 1,
 *         InstanceSize = AzureNative.DocumentDB.ServiceSize.Cosmos_D4s,
 *         ResourceGroupName = "rg1",
 *         ServiceName = "SqlDedicatedGateway",
 *         ServiceType = AzureNative.DocumentDB.ServiceType.SqlDedicatedGateway,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/documentdb/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := documentdb.NewService(ctx, "service", &documentdb.ServiceArgs{
 * 			AccountName:       pulumi.String("ddb1"),
 * 			InstanceCount:     pulumi.Int(1),
 * 			InstanceSize:      pulumi.String(documentdb.ServiceSize_Cosmos_D4s),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("SqlDedicatedGateway"),
 * 			ServiceType:       pulumi.String(documentdb.ServiceTypeSqlDedicatedGateway),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.documentdb.Service;
 * import com.pulumi.azurenative.documentdb.ServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var service = new Service("service", ServiceArgs.builder()
 *             .accountName("ddb1")
 *             .instanceCount(1)
 *             .instanceSize("Cosmos.D4s")
 *             .resourceGroupName("rg1")
 *             .serviceName("SqlDedicatedGateway")
 *             .serviceType("SqlDedicatedGateway")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:documentdb:Service SqlDedicatedGateway /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/services/{serviceName}
 * ```
 * @property accountName Cosmos DB database account name.
 * @property instanceCount Instance count for the service.
 * @property instanceSize Instance type for the service.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName Cosmos DB service name.
 * @property serviceType ServiceType for the service.
 */
public data class ServiceArgs(
    public val accountName: Output<String>? = null,
    public val instanceCount: Output<Int>? = null,
    public val instanceSize: Output<Either<String, ServiceSize>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
    public val serviceType: Output<Either<String, ServiceType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.ServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.ServiceArgs =
        com.pulumi.azurenative.documentdb.ServiceArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .instanceCount(instanceCount?.applyValue({ args0 -> args0 }))
            .instanceSize(
                instanceSize?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 }))
            .serviceType(
                serviceType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [ServiceArgs].
 */
@PulumiTagMarker
public class ServiceArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var instanceCount: Output<Int>? = null

    private var instanceSize: Output<Either<String, ServiceSize>>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceName: Output<String>? = null

    private var serviceType: Output<Either<String, ServiceType>>? = null

    /**
     * @param value Cosmos DB database account name.
     */
    @JvmName("pnonksvfoqigywki")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value Instance count for the service.
     */
    @JvmName("porxylxqetbadbed")
    public suspend fun instanceCount(`value`: Output<Int>) {
        this.instanceCount = value
    }

    /**
     * @param value Instance type for the service.
     */
    @JvmName("kvjpbwjytxtkegxx")
    public suspend fun instanceSize(`value`: Output<Either<String, ServiceSize>>) {
        this.instanceSize = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("cmyfbjmolornafum")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Cosmos DB service name.
     */
    @JvmName("mynrdfvidunogamd")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value ServiceType for the service.
     */
    @JvmName("dfjxxmujkolguoeq")
    public suspend fun serviceType(`value`: Output<Either<String, ServiceType>>) {
        this.serviceType = value
    }

    /**
     * @param value Cosmos DB database account name.
     */
    @JvmName("dnwcutupktideesk")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value Instance count for the service.
     */
    @JvmName("nwxygicrjhhtxqjt")
    public suspend fun instanceCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceCount = mapped
    }

    /**
     * @param value Instance type for the service.
     */
    @JvmName("cbogcsofsxqlwrvo")
    public suspend fun instanceSize(`value`: Either<String, ServiceSize>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceSize = mapped
    }

    /**
     * @param value Instance type for the service.
     */
    @JvmName("ionssjcuhnjfbwha")
    public fun instanceSize(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ServiceSize>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceSize = mapped
    }

    /**
     * @param value Instance type for the service.
     */
    @JvmName("uihmxqxkgqjypkyp")
    public fun instanceSize(`value`: ServiceSize) {
        val toBeMapped = Either.ofRight<String, ServiceSize>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceSize = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("pvvgluiljgpbneus")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Cosmos DB service name.
     */
    @JvmName("uijyregqdxrdplmh")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    /**
     * @param value ServiceType for the service.
     */
    @JvmName("sylfrkpshuwowqnf")
    public suspend fun serviceType(`value`: Either<String, ServiceType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceType = mapped
    }

    /**
     * @param value ServiceType for the service.
     */
    @JvmName("umarklxtwcamdnsi")
    public fun serviceType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ServiceType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serviceType = mapped
    }

    /**
     * @param value ServiceType for the service.
     */
    @JvmName("miekiwstfuhtkdpm")
    public fun serviceType(`value`: ServiceType) {
        val toBeMapped = Either.ofRight<String, ServiceType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serviceType = mapped
    }

    internal fun build(): ServiceArgs = ServiceArgs(
        accountName = accountName,
        instanceCount = instanceCount,
        instanceSize = instanceSize,
        resourceGroupName = resourceGroupName,
        serviceName = serviceName,
        serviceType = serviceType,
    )
}
