@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin

import com.pulumi.azurenative.documentdb.SqlResourceSqlRoleAssignmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * An Azure Cosmos DB Role Assignment
 * Azure REST API version: 2023-04-15. Prior API version in Azure Native 1.x: 2021-03-01-preview.
 * Other available API versions: 2023-09-15, 2023-09-15-preview, 2023-11-15, 2023-11-15-preview, 2024-02-15-preview, 2024-05-15, 2024-05-15-preview.
 * ## Example Usage
 * ### CosmosDBSqlRoleAssignmentCreateUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlResourceSqlRoleAssignment = new AzureNative.DocumentDB.SqlResourceSqlRoleAssignment("sqlResourceSqlRoleAssignment", new()
 *     {
 *         AccountName = "myAccountName",
 *         PrincipalId = "myPrincipalId",
 *         ResourceGroupName = "myResourceGroupName",
 *         RoleAssignmentId = "myRoleAssignmentId",
 *         RoleDefinitionId = "/subscriptions/mySubscriptionId/resourceGroups/myResourceGroupName/providers/Microsoft.DocumentDB/databaseAccounts/myAccountName/sqlRoleDefinitions/myRoleDefinitionId",
 *         Scope = "/subscriptions/mySubscriptionId/resourceGroups/myResourceGroupName/providers/Microsoft.DocumentDB/databaseAccounts/myAccountName/dbs/purchases/colls/redmond-purchases",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/documentdb/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := documentdb.NewSqlResourceSqlRoleAssignment(ctx, "sqlResourceSqlRoleAssignment", &documentdb.SqlResourceSqlRoleAssignmentArgs{
 * 			AccountName:       pulumi.String("myAccountName"),
 * 			PrincipalId:       pulumi.String("myPrincipalId"),
 * 			ResourceGroupName: pulumi.String("myResourceGroupName"),
 * 			RoleAssignmentId:  pulumi.String("myRoleAssignmentId"),
 * 			RoleDefinitionId:  pulumi.String("/subscriptions/mySubscriptionId/resourceGroups/myResourceGroupName/providers/Microsoft.DocumentDB/databaseAccounts/myAccountName/sqlRoleDefinitions/myRoleDefinitionId"),
 * 			Scope:             pulumi.String("/subscriptions/mySubscriptionId/resourceGroups/myResourceGroupName/providers/Microsoft.DocumentDB/databaseAccounts/myAccountName/dbs/purchases/colls/redmond-purchases"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.documentdb.SqlResourceSqlRoleAssignment;
 * import com.pulumi.azurenative.documentdb.SqlResourceSqlRoleAssignmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlResourceSqlRoleAssignment = new SqlResourceSqlRoleAssignment("sqlResourceSqlRoleAssignment", SqlResourceSqlRoleAssignmentArgs.builder()
 *             .accountName("myAccountName")
 *             .principalId("myPrincipalId")
 *             .resourceGroupName("myResourceGroupName")
 *             .roleAssignmentId("myRoleAssignmentId")
 *             .roleDefinitionId("/subscriptions/mySubscriptionId/resourceGroups/myResourceGroupName/providers/Microsoft.DocumentDB/databaseAccounts/myAccountName/sqlRoleDefinitions/myRoleDefinitionId")
 *             .scope("/subscriptions/mySubscriptionId/resourceGroups/myResourceGroupName/providers/Microsoft.DocumentDB/databaseAccounts/myAccountName/dbs/purchases/colls/redmond-purchases")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:documentdb:SqlResourceSqlRoleAssignment myRoleAssignmentId /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlRoleAssignments/{roleAssignmentId}
 * ```
 * @property accountName Cosmos DB database account name.
 * @property principalId The unique identifier for the associated AAD principal in the AAD graph to which access is being granted through this Role Assignment. Tenant ID for the principal is inferred using the tenant associated with the subscription.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property roleAssignmentId The GUID for the Role Assignment.
 * @property roleDefinitionId The unique identifier for the associated Role Definition.
 * @property scope The data plane resource path for which access is being granted through this Role Assignment.
 */
public data class SqlResourceSqlRoleAssignmentArgs(
    public val accountName: Output<String>? = null,
    public val principalId: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val roleAssignmentId: Output<String>? = null,
    public val roleDefinitionId: Output<String>? = null,
    public val scope: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.SqlResourceSqlRoleAssignmentArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.SqlResourceSqlRoleAssignmentArgs =
        com.pulumi.azurenative.documentdb.SqlResourceSqlRoleAssignmentArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .principalId(principalId?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .roleAssignmentId(roleAssignmentId?.applyValue({ args0 -> args0 }))
            .roleDefinitionId(roleDefinitionId?.applyValue({ args0 -> args0 }))
            .scope(scope?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SqlResourceSqlRoleAssignmentArgs].
 */
@PulumiTagMarker
public class SqlResourceSqlRoleAssignmentArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var principalId: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var roleAssignmentId: Output<String>? = null

    private var roleDefinitionId: Output<String>? = null

    private var scope: Output<String>? = null

    /**
     * @param value Cosmos DB database account name.
     */
    @JvmName("cxiyewprbyumvgte")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value The unique identifier for the associated AAD principal in the AAD graph to which access is being granted through this Role Assignment. Tenant ID for the principal is inferred using the tenant associated with the subscription.
     */
    @JvmName("rootuuvanflvlaju")
    public suspend fun principalId(`value`: Output<String>) {
        this.principalId = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ocwbxicgtpivhend")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The GUID for the Role Assignment.
     */
    @JvmName("ydymjinkpnnggymw")
    public suspend fun roleAssignmentId(`value`: Output<String>) {
        this.roleAssignmentId = value
    }

    /**
     * @param value The unique identifier for the associated Role Definition.
     */
    @JvmName("ecvcyroixravkfds")
    public suspend fun roleDefinitionId(`value`: Output<String>) {
        this.roleDefinitionId = value
    }

    /**
     * @param value The data plane resource path for which access is being granted through this Role Assignment.
     */
    @JvmName("sqxfviquxcgiiacx")
    public suspend fun scope(`value`: Output<String>) {
        this.scope = value
    }

    /**
     * @param value Cosmos DB database account name.
     */
    @JvmName("fyqipssejlewvixa")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value The unique identifier for the associated AAD principal in the AAD graph to which access is being granted through this Role Assignment. Tenant ID for the principal is inferred using the tenant associated with the subscription.
     */
    @JvmName("wspvxmxveumevkda")
    public suspend fun principalId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.principalId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("dgkutcquuaxybjpv")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The GUID for the Role Assignment.
     */
    @JvmName("ddhgnjtvlwayvvma")
    public suspend fun roleAssignmentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleAssignmentId = mapped
    }

    /**
     * @param value The unique identifier for the associated Role Definition.
     */
    @JvmName("iejpffgetrmtcwqf")
    public suspend fun roleDefinitionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleDefinitionId = mapped
    }

    /**
     * @param value The data plane resource path for which access is being granted through this Role Assignment.
     */
    @JvmName("khagfmnstgcwqxhx")
    public suspend fun scope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    internal fun build(): SqlResourceSqlRoleAssignmentArgs = SqlResourceSqlRoleAssignmentArgs(
        accountName = accountName,
        principalId = principalId,
        resourceGroupName = resourceGroupName,
        roleAssignmentId = roleAssignmentId,
        roleDefinitionId = roleDefinitionId,
        scope = scope,
    )
}
