@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Indicates the type of database account. This can only be set at database account creation.
 */
public enum class DatabaseAccountKind(
    public val javaValue: com.pulumi.azurenative.documentdb.enums.DatabaseAccountKind,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.enums.DatabaseAccountKind> {
    GlobalDocumentDB(com.pulumi.azurenative.documentdb.enums.DatabaseAccountKind.GlobalDocumentDB),
    MongoDB(com.pulumi.azurenative.documentdb.enums.DatabaseAccountKind.MongoDB),
    Parse(com.pulumi.azurenative.documentdb.enums.DatabaseAccountKind.Parse),
    ;

    override fun toJava(): com.pulumi.azurenative.documentdb.enums.DatabaseAccountKind = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.documentdb.enums.DatabaseAccountKind): DatabaseAccountKind = DatabaseAccountKind.values().first { it.javaValue == javaType }
    }
}
