@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The default consistency level and configuration settings of the Cosmos DB account.
 */
public enum class DefaultConsistencyLevel(
    public val javaValue: com.pulumi.azurenative.documentdb.enums.DefaultConsistencyLevel,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.enums.DefaultConsistencyLevel> {
    Eventual(com.pulumi.azurenative.documentdb.enums.DefaultConsistencyLevel.Eventual),
    Session(com.pulumi.azurenative.documentdb.enums.DefaultConsistencyLevel.Session),
    BoundedStaleness(com.pulumi.azurenative.documentdb.enums.DefaultConsistencyLevel.BoundedStaleness),
    Strong(com.pulumi.azurenative.documentdb.enums.DefaultConsistencyLevel.Strong),
    ConsistentPrefix(com.pulumi.azurenative.documentdb.enums.DefaultConsistencyLevel.ConsistentPrefix),
    ;

    override fun toJava(): com.pulumi.azurenative.documentdb.enums.DefaultConsistencyLevel = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.documentdb.enums.DefaultConsistencyLevel): DefaultConsistencyLevel =
            DefaultConsistencyLevel.values().first { it.javaValue == javaType }
    }
}
