@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Indicates the minimum allowed Tls version. The default value is Tls 1.2. Cassandra and Mongo APIs only work with Tls 1.2.
 */
public enum class MinimalTlsVersion(
    public val javaValue: com.pulumi.azurenative.documentdb.enums.MinimalTlsVersion,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.enums.MinimalTlsVersion> {
    Tls(com.pulumi.azurenative.documentdb.enums.MinimalTlsVersion.Tls),
    Tls11(com.pulumi.azurenative.documentdb.enums.MinimalTlsVersion.Tls11),
    Tls12(com.pulumi.azurenative.documentdb.enums.MinimalTlsVersion.Tls12),
    ;

    override fun toJava(): com.pulumi.azurenative.documentdb.enums.MinimalTlsVersion = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.documentdb.enums.MinimalTlsVersion): MinimalTlsVersion = MinimalTlsVersion.values().first { it.javaValue == javaType }
    }
}
