@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.AnalyticalStorageConfigurationArgs.builder
import com.pulumi.azurenative.documentdb.kotlin.enums.AnalyticalStorageSchemaType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Analytical storage specific properties.
 * @property schemaType Describes the types of schema for analytical storage.
 */
public data class AnalyticalStorageConfigurationArgs(
    public val schemaType: Output<Either<String, AnalyticalStorageSchemaType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.AnalyticalStorageConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.inputs.AnalyticalStorageConfigurationArgs = com.pulumi.azurenative.documentdb.inputs.AnalyticalStorageConfigurationArgs.builder()
        .schemaType(
            schemaType?.applyValue({ args0 ->
                args0.transform({ args0 -> args0 }, { args0 ->
                    args0.let({ args0 -> args0.toJava() })
                })
            }),
        ).build()
}

/**
 * Builder for [AnalyticalStorageConfigurationArgs].
 */
@PulumiTagMarker
public class AnalyticalStorageConfigurationArgsBuilder internal constructor() {
    private var schemaType: Output<Either<String, AnalyticalStorageSchemaType>>? = null

    /**
     * @param value Describes the types of schema for analytical storage.
     */
    @JvmName("qhxiypjnlrakfbgs")
    public suspend fun schemaType(`value`: Output<Either<String, AnalyticalStorageSchemaType>>) {
        this.schemaType = value
    }

    /**
     * @param value Describes the types of schema for analytical storage.
     */
    @JvmName("tmmfgblwnmhuyegr")
    public suspend fun schemaType(`value`: Either<String, AnalyticalStorageSchemaType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schemaType = mapped
    }

    /**
     * @param value Describes the types of schema for analytical storage.
     */
    @JvmName("utxvnclyfwkhacbw")
    public fun schemaType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AnalyticalStorageSchemaType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.schemaType = mapped
    }

    /**
     * @param value Describes the types of schema for analytical storage.
     */
    @JvmName("xhgdpcimmflacuqr")
    public fun schemaType(`value`: AnalyticalStorageSchemaType) {
        val toBeMapped = Either.ofRight<String, AnalyticalStorageSchemaType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.schemaType = mapped
    }

    internal fun build(): AnalyticalStorageConfigurationArgs = AnalyticalStorageConfigurationArgs(
        schemaType = schemaType,
    )
}
