@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.ApiPropertiesArgs.builder
import com.pulumi.azurenative.documentdb.kotlin.enums.ServerVersion
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property serverVersion Describes the ServerVersion of an a MongoDB account.
 */
public data class ApiPropertiesArgs(
    public val serverVersion: Output<Either<String, ServerVersion>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.ApiPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.inputs.ApiPropertiesArgs =
        com.pulumi.azurenative.documentdb.inputs.ApiPropertiesArgs.builder()
            .serverVersion(
                serverVersion?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [ApiPropertiesArgs].
 */
@PulumiTagMarker
public class ApiPropertiesArgsBuilder internal constructor() {
    private var serverVersion: Output<Either<String, ServerVersion>>? = null

    /**
     * @param value Describes the ServerVersion of an a MongoDB account.
     */
    @JvmName("ccfpcoialfaxeeij")
    public suspend fun serverVersion(`value`: Output<Either<String, ServerVersion>>) {
        this.serverVersion = value
    }

    /**
     * @param value Describes the ServerVersion of an a MongoDB account.
     */
    @JvmName("vcwkyllvvapgacil")
    public suspend fun serverVersion(`value`: Either<String, ServerVersion>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverVersion = mapped
    }

    /**
     * @param value Describes the ServerVersion of an a MongoDB account.
     */
    @JvmName("iwxeyjdfoqaetyiu")
    public fun serverVersion(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ServerVersion>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serverVersion = mapped
    }

    /**
     * @param value Describes the ServerVersion of an a MongoDB account.
     */
    @JvmName("lylofcfbgiphouew")
    public fun serverVersion(`value`: ServerVersion) {
        val toBeMapped = Either.ofRight<String, ServerVersion>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serverVersion = mapped
    }

    internal fun build(): ApiPropertiesArgs = ApiPropertiesArgs(
        serverVersion = serverVersion,
    )
}
