@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.AuthenticationMethodLdapPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Ldap authentication method properties. This feature is in preview.
 * @property connectionTimeoutInMs Timeout for connecting to the LDAP server in miliseconds. The default is 5000 ms.
 * @property searchBaseDistinguishedName Distinguished name of the object to start the recursive search of users from.
 * @property searchFilterTemplate Template to use for searching. Defaults to (cn=%s) where %s will be replaced by the username used to login.
 * @property serverCertificates
 * @property serverHostname Hostname of the LDAP server.
 * @property serverPort Port of the LDAP server.
 * @property serviceUserDistinguishedName Distinguished name of the look up user account, who can look up user details on authentication.
 * @property serviceUserPassword Password of the look up user.
 */
public data class AuthenticationMethodLdapPropertiesArgs(
    public val connectionTimeoutInMs: Output<Int>? = null,
    public val searchBaseDistinguishedName: Output<String>? = null,
    public val searchFilterTemplate: Output<String>? = null,
    public val serverCertificates: Output<List<CertificateArgs>>? = null,
    public val serverHostname: Output<String>? = null,
    public val serverPort: Output<Int>? = null,
    public val serviceUserDistinguishedName: Output<String>? = null,
    public val serviceUserPassword: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.AuthenticationMethodLdapPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.inputs.AuthenticationMethodLdapPropertiesArgs =
        com.pulumi.azurenative.documentdb.inputs.AuthenticationMethodLdapPropertiesArgs.builder()
            .connectionTimeoutInMs(connectionTimeoutInMs?.applyValue({ args0 -> args0 }))
            .searchBaseDistinguishedName(searchBaseDistinguishedName?.applyValue({ args0 -> args0 }))
            .searchFilterTemplate(searchFilterTemplate?.applyValue({ args0 -> args0 }))
            .serverCertificates(
                serverCertificates?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .serverHostname(serverHostname?.applyValue({ args0 -> args0 }))
            .serverPort(serverPort?.applyValue({ args0 -> args0 }))
            .serviceUserDistinguishedName(serviceUserDistinguishedName?.applyValue({ args0 -> args0 }))
            .serviceUserPassword(serviceUserPassword?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AuthenticationMethodLdapPropertiesArgs].
 */
@PulumiTagMarker
public class AuthenticationMethodLdapPropertiesArgsBuilder internal constructor() {
    private var connectionTimeoutInMs: Output<Int>? = null

    private var searchBaseDistinguishedName: Output<String>? = null

    private var searchFilterTemplate: Output<String>? = null

    private var serverCertificates: Output<List<CertificateArgs>>? = null

    private var serverHostname: Output<String>? = null

    private var serverPort: Output<Int>? = null

    private var serviceUserDistinguishedName: Output<String>? = null

    private var serviceUserPassword: Output<String>? = null

    /**
     * @param value Timeout for connecting to the LDAP server in miliseconds. The default is 5000 ms.
     */
    @JvmName("dtexuabmymsriljp")
    public suspend fun connectionTimeoutInMs(`value`: Output<Int>) {
        this.connectionTimeoutInMs = value
    }

    /**
     * @param value Distinguished name of the object to start the recursive search of users from.
     */
    @JvmName("wavkiwobpedwrtgw")
    public suspend fun searchBaseDistinguishedName(`value`: Output<String>) {
        this.searchBaseDistinguishedName = value
    }

    /**
     * @param value Template to use for searching. Defaults to (cn=%s) where %s will be replaced by the username used to login.
     */
    @JvmName("dhpwnlmyehbrkfdm")
    public suspend fun searchFilterTemplate(`value`: Output<String>) {
        this.searchFilterTemplate = value
    }

    /**
     * @param value
     */
    @JvmName("djqikolyjyjowjlu")
    public suspend fun serverCertificates(`value`: Output<List<CertificateArgs>>) {
        this.serverCertificates = value
    }

    @JvmName("smhuscilyadboflw")
    public suspend fun serverCertificates(vararg values: Output<CertificateArgs>) {
        this.serverCertificates = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("wxqphrmdwsscmimt")
    public suspend fun serverCertificates(values: List<Output<CertificateArgs>>) {
        this.serverCertificates = Output.all(values)
    }

    /**
     * @param value Hostname of the LDAP server.
     */
    @JvmName("ubtvtoukhcvwjwsh")
    public suspend fun serverHostname(`value`: Output<String>) {
        this.serverHostname = value
    }

    /**
     * @param value Port of the LDAP server.
     */
    @JvmName("jmlmnajbxoxwttjc")
    public suspend fun serverPort(`value`: Output<Int>) {
        this.serverPort = value
    }

    /**
     * @param value Distinguished name of the look up user account, who can look up user details on authentication.
     */
    @JvmName("cfcwlblqskugnljv")
    public suspend fun serviceUserDistinguishedName(`value`: Output<String>) {
        this.serviceUserDistinguishedName = value
    }

    /**
     * @param value Password of the look up user.
     */
    @JvmName("kqfpqfysqrqytbcw")
    public suspend fun serviceUserPassword(`value`: Output<String>) {
        this.serviceUserPassword = value
    }

    /**
     * @param value Timeout for connecting to the LDAP server in miliseconds. The default is 5000 ms.
     */
    @JvmName("gcknfofxqdfiivrw")
    public suspend fun connectionTimeoutInMs(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionTimeoutInMs = mapped
    }

    /**
     * @param value Distinguished name of the object to start the recursive search of users from.
     */
    @JvmName("pavlcouuojbemnpq")
    public suspend fun searchBaseDistinguishedName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.searchBaseDistinguishedName = mapped
    }

    /**
     * @param value Template to use for searching. Defaults to (cn=%s) where %s will be replaced by the username used to login.
     */
    @JvmName("asygsrvhkepudsjk")
    public suspend fun searchFilterTemplate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.searchFilterTemplate = mapped
    }

    /**
     * @param value
     */
    @JvmName("dwjwonmrcavluiwq")
    public suspend fun serverCertificates(`value`: List<CertificateArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverCertificates = mapped
    }

    /**
     * @param argument
     */
    @JvmName("leyqyhploppxwirr")
    public suspend fun serverCertificates(argument: List<suspend CertificateArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { CertificateArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.serverCertificates = mapped
    }

    /**
     * @param argument
     */
    @JvmName("macmckoqxuueeckd")
    public suspend fun serverCertificates(vararg argument: suspend CertificateArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { CertificateArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.serverCertificates = mapped
    }

    /**
     * @param argument
     */
    @JvmName("jdnvtbolvggxuwvr")
    public suspend fun serverCertificates(argument: suspend CertificateArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(CertificateArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.serverCertificates = mapped
    }

    /**
     * @param values
     */
    @JvmName("ueuhgoaxygpmxqpx")
    public suspend fun serverCertificates(vararg values: CertificateArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serverCertificates = mapped
    }

    /**
     * @param value Hostname of the LDAP server.
     */
    @JvmName("bqhjhamegyphrhyb")
    public suspend fun serverHostname(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverHostname = mapped
    }

    /**
     * @param value Port of the LDAP server.
     */
    @JvmName("asyljlikuqpgrjfj")
    public suspend fun serverPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverPort = mapped
    }

    /**
     * @param value Distinguished name of the look up user account, who can look up user details on authentication.
     */
    @JvmName("lsrukmjccrvomouw")
    public suspend fun serviceUserDistinguishedName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceUserDistinguishedName = mapped
    }

    /**
     * @param value Password of the look up user.
     */
    @JvmName("yuonncwlvrvdqxbx")
    public suspend fun serviceUserPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceUserPassword = mapped
    }

    internal fun build(): AuthenticationMethodLdapPropertiesArgs =
        AuthenticationMethodLdapPropertiesArgs(
            connectionTimeoutInMs = connectionTimeoutInMs,
            searchBaseDistinguishedName = searchBaseDistinguishedName,
            searchFilterTemplate = searchFilterTemplate,
            serverCertificates = serverCertificates,
            serverHostname = serverHostname,
            serverPort = serverPort,
            serviceUserDistinguishedName = serviceUserDistinguishedName,
            serviceUserPassword = serviceUserPassword,
        )
}
