@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.AutoscaleSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property maxThroughput Represents maximum throughput, the resource can scale up to.
 */
public data class AutoscaleSettingsArgs(
    public val maxThroughput: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.AutoscaleSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.inputs.AutoscaleSettingsArgs =
        com.pulumi.azurenative.documentdb.inputs.AutoscaleSettingsArgs.builder()
            .maxThroughput(maxThroughput?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AutoscaleSettingsArgs].
 */
@PulumiTagMarker
public class AutoscaleSettingsArgsBuilder internal constructor() {
    private var maxThroughput: Output<Int>? = null

    /**
     * @param value Represents maximum throughput, the resource can scale up to.
     */
    @JvmName("emknwqiqshkeeyrv")
    public suspend fun maxThroughput(`value`: Output<Int>) {
        this.maxThroughput = value
    }

    /**
     * @param value Represents maximum throughput, the resource can scale up to.
     */
    @JvmName("gpavswsifpsyyjlb")
    public suspend fun maxThroughput(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxThroughput = mapped
    }

    internal fun build(): AutoscaleSettingsArgs = AutoscaleSettingsArgs(
        maxThroughput = maxThroughput,
    )
}
