@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.BackupPolicyMigrationStateArgs.builder
import com.pulumi.azurenative.documentdb.kotlin.enums.BackupPolicyMigrationStatus
import com.pulumi.azurenative.documentdb.kotlin.enums.BackupPolicyType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The object representing the state of the migration between the backup policies.
 * @property startTime Time at which the backup policy migration started (ISO-8601 format).
 * @property status Describes the status of migration between backup policy types.
 * @property targetType Describes the target backup policy type of the backup policy migration.
 */
public data class BackupPolicyMigrationStateArgs(
    public val startTime: Output<String>? = null,
    public val status: Output<Either<String, BackupPolicyMigrationStatus>>? = null,
    public val targetType: Output<Either<String, BackupPolicyType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.BackupPolicyMigrationStateArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.inputs.BackupPolicyMigrationStateArgs =
        com.pulumi.azurenative.documentdb.inputs.BackupPolicyMigrationStateArgs.builder()
            .startTime(startTime?.applyValue({ args0 -> args0 }))
            .status(
                status?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .targetType(
                targetType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [BackupPolicyMigrationStateArgs].
 */
@PulumiTagMarker
public class BackupPolicyMigrationStateArgsBuilder internal constructor() {
    private var startTime: Output<String>? = null

    private var status: Output<Either<String, BackupPolicyMigrationStatus>>? = null

    private var targetType: Output<Either<String, BackupPolicyType>>? = null

    /**
     * @param value Time at which the backup policy migration started (ISO-8601 format).
     */
    @JvmName("ywewsmgdkqoabrjj")
    public suspend fun startTime(`value`: Output<String>) {
        this.startTime = value
    }

    /**
     * @param value Describes the status of migration between backup policy types.
     */
    @JvmName("imuoyoddxrjxqivr")
    public suspend fun status(`value`: Output<Either<String, BackupPolicyMigrationStatus>>) {
        this.status = value
    }

    /**
     * @param value Describes the target backup policy type of the backup policy migration.
     */
    @JvmName("fyfysfbtjroqbkph")
    public suspend fun targetType(`value`: Output<Either<String, BackupPolicyType>>) {
        this.targetType = value
    }

    /**
     * @param value Time at which the backup policy migration started (ISO-8601 format).
     */
    @JvmName("vivkldieiatrshgb")
    public suspend fun startTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startTime = mapped
    }

    /**
     * @param value Describes the status of migration between backup policy types.
     */
    @JvmName("qcdjsdeqppcqpygb")
    public suspend fun status(`value`: Either<String, BackupPolicyMigrationStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Describes the status of migration between backup policy types.
     */
    @JvmName("bievhlvwnxiohauw")
    public fun status(`value`: String) {
        val toBeMapped = Either.ofLeft<String, BackupPolicyMigrationStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Describes the status of migration between backup policy types.
     */
    @JvmName("ujoavprulnbrtrmx")
    public fun status(`value`: BackupPolicyMigrationStatus) {
        val toBeMapped = Either.ofRight<String, BackupPolicyMigrationStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Describes the target backup policy type of the backup policy migration.
     */
    @JvmName("fafqakncgueltxog")
    public suspend fun targetType(`value`: Either<String, BackupPolicyType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetType = mapped
    }

    /**
     * @param value Describes the target backup policy type of the backup policy migration.
     */
    @JvmName("trxlwltkevctsljj")
    public fun targetType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, BackupPolicyType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetType = mapped
    }

    /**
     * @param value Describes the target backup policy type of the backup policy migration.
     */
    @JvmName("xdcmtanlrewdmvan")
    public fun targetType(`value`: BackupPolicyType) {
        val toBeMapped = Either.ofRight<String, BackupPolicyType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetType = mapped
    }

    internal fun build(): BackupPolicyMigrationStateArgs = BackupPolicyMigrationStateArgs(
        startTime = startTime,
        status = status,
        targetType = targetType,
    )
}
