@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.ClusterKeyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Cosmos DB Cassandra table cluster key
 * @property name Name of the Cosmos DB Cassandra table cluster key
 * @property orderBy Order of the Cosmos DB Cassandra table cluster key, only support "Asc" and "Desc"
 */
public data class ClusterKeyArgs(
    public val name: Output<String>? = null,
    public val orderBy: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.ClusterKeyArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.inputs.ClusterKeyArgs =
        com.pulumi.azurenative.documentdb.inputs.ClusterKeyArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .orderBy(orderBy?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterKeyArgs].
 */
@PulumiTagMarker
public class ClusterKeyArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var orderBy: Output<String>? = null

    /**
     * @param value Name of the Cosmos DB Cassandra table cluster key
     */
    @JvmName("amxqwsivqbgimvsb")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Order of the Cosmos DB Cassandra table cluster key, only support "Asc" and "Desc"
     */
    @JvmName("foyicriprkpwdenu")
    public suspend fun orderBy(`value`: Output<String>) {
        this.orderBy = value
    }

    /**
     * @param value Name of the Cosmos DB Cassandra table cluster key
     */
    @JvmName("uocikxeyudrhxftn")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Order of the Cosmos DB Cassandra table cluster key, only support "Asc" and "Desc"
     */
    @JvmName("hprmshnuljfvybnr")
    public suspend fun orderBy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.orderBy = mapped
    }

    internal fun build(): ClusterKeyArgs = ClusterKeyArgs(
        name = name,
        orderBy = orderBy,
    )
}
