@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.ConflictResolutionPolicyArgs.builder
import com.pulumi.azurenative.documentdb.kotlin.enums.ConflictResolutionMode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The conflict resolution policy for the container.
 * @property conflictResolutionPath The conflict resolution path in the case of LastWriterWins mode.
 * @property conflictResolutionProcedure The procedure to resolve conflicts in the case of custom mode.
 * @property mode Indicates the conflict resolution mode.
 */
public data class ConflictResolutionPolicyArgs(
    public val conflictResolutionPath: Output<String>? = null,
    public val conflictResolutionProcedure: Output<String>? = null,
    public val mode: Output<Either<String, ConflictResolutionMode>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.ConflictResolutionPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.inputs.ConflictResolutionPolicyArgs =
        com.pulumi.azurenative.documentdb.inputs.ConflictResolutionPolicyArgs.builder()
            .conflictResolutionPath(conflictResolutionPath?.applyValue({ args0 -> args0 }))
            .conflictResolutionProcedure(conflictResolutionProcedure?.applyValue({ args0 -> args0 }))
            .mode(
                mode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ConflictResolutionPolicyArgs].
 */
@PulumiTagMarker
public class ConflictResolutionPolicyArgsBuilder internal constructor() {
    private var conflictResolutionPath: Output<String>? = null

    private var conflictResolutionProcedure: Output<String>? = null

    private var mode: Output<Either<String, ConflictResolutionMode>>? = null

    /**
     * @param value The conflict resolution path in the case of LastWriterWins mode.
     */
    @JvmName("cwhynrrfunvmupba")
    public suspend fun conflictResolutionPath(`value`: Output<String>) {
        this.conflictResolutionPath = value
    }

    /**
     * @param value The procedure to resolve conflicts in the case of custom mode.
     */
    @JvmName("lsvvopuoesgsfaku")
    public suspend fun conflictResolutionProcedure(`value`: Output<String>) {
        this.conflictResolutionProcedure = value
    }

    /**
     * @param value Indicates the conflict resolution mode.
     */
    @JvmName("mojimjofcnfdfauv")
    public suspend fun mode(`value`: Output<Either<String, ConflictResolutionMode>>) {
        this.mode = value
    }

    /**
     * @param value The conflict resolution path in the case of LastWriterWins mode.
     */
    @JvmName("qvpkjhkoscuqqkfc")
    public suspend fun conflictResolutionPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.conflictResolutionPath = mapped
    }

    /**
     * @param value The procedure to resolve conflicts in the case of custom mode.
     */
    @JvmName("cpejxmfuktbstulf")
    public suspend fun conflictResolutionProcedure(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.conflictResolutionProcedure = mapped
    }

    /**
     * @param value Indicates the conflict resolution mode.
     */
    @JvmName("spdulinrvtgnijtu")
    public suspend fun mode(`value`: Either<String, ConflictResolutionMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value Indicates the conflict resolution mode.
     */
    @JvmName("rxaoaknkikmtpwvr")
    public fun mode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ConflictResolutionMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value Indicates the conflict resolution mode.
     */
    @JvmName("xhfnttycfeeqoupf")
    public fun mode(`value`: ConflictResolutionMode) {
        val toBeMapped = Either.ofRight<String, ConflictResolutionMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    internal fun build(): ConflictResolutionPolicyArgs = ConflictResolutionPolicyArgs(
        conflictResolutionPath = conflictResolutionPath,
        conflictResolutionProcedure = conflictResolutionProcedure,
        mode = mode,
    )
}
