@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.ContinuousModePropertiesArgs.builder
import com.pulumi.azurenative.documentdb.kotlin.enums.ContinuousTier
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Configuration values for periodic mode backup
 * @property tier Enum to indicate type of Continuous backup mode
 */
public data class ContinuousModePropertiesArgs(
    public val tier: Output<Either<String, ContinuousTier>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.ContinuousModePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.inputs.ContinuousModePropertiesArgs =
        com.pulumi.azurenative.documentdb.inputs.ContinuousModePropertiesArgs.builder()
            .tier(
                tier?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ContinuousModePropertiesArgs].
 */
@PulumiTagMarker
public class ContinuousModePropertiesArgsBuilder internal constructor() {
    private var tier: Output<Either<String, ContinuousTier>>? = null

    /**
     * @param value Enum to indicate type of Continuous backup mode
     */
    @JvmName("hralesjqncgrqtee")
    public suspend fun tier(`value`: Output<Either<String, ContinuousTier>>) {
        this.tier = value
    }

    /**
     * @param value Enum to indicate type of Continuous backup mode
     */
    @JvmName("wdrchtojrbewpdmw")
    public suspend fun tier(`value`: Either<String, ContinuousTier>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    /**
     * @param value Enum to indicate type of Continuous backup mode
     */
    @JvmName("xywkglujvlswfxbg")
    public fun tier(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ContinuousTier>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    /**
     * @param value Enum to indicate type of Continuous backup mode
     */
    @JvmName("tvsiyhkspcdrsnbi")
    public fun tier(`value`: ContinuousTier) {
        val toBeMapped = Either.ofRight<String, ContinuousTier>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    internal fun build(): ContinuousModePropertiesArgs = ContinuousModePropertiesArgs(
        tier = tier,
    )
}
