@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.GetDatabaseAccountPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName Cosmos DB database account name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetDatabaseAccountPlainArgs(
    public val accountName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.GetDatabaseAccountPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.inputs.GetDatabaseAccountPlainArgs =
        com.pulumi.azurenative.documentdb.inputs.GetDatabaseAccountPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDatabaseAccountPlainArgs].
 */
@PulumiTagMarker
public class GetDatabaseAccountPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Cosmos DB database account name.
     */
    @JvmName("ookddkwsacbrkiub")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("osmevhaerkosftoc")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetDatabaseAccountPlainArgs = GetDatabaseAccountPlainArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
