@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.GetFirewallRulePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property firewallRuleName The name of the mongo cluster firewall rule.
 * @property mongoClusterName The name of the mongo cluster.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetFirewallRulePlainArgs(
    public val firewallRuleName: String,
    public val mongoClusterName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.GetFirewallRulePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.inputs.GetFirewallRulePlainArgs =
        com.pulumi.azurenative.documentdb.inputs.GetFirewallRulePlainArgs.builder()
            .firewallRuleName(firewallRuleName.let({ args0 -> args0 }))
            .mongoClusterName(mongoClusterName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetFirewallRulePlainArgs].
 */
@PulumiTagMarker
public class GetFirewallRulePlainArgsBuilder internal constructor() {
    private var firewallRuleName: String? = null

    private var mongoClusterName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the mongo cluster firewall rule.
     */
    @JvmName("gyjqonsrjwxciujx")
    public suspend fun firewallRuleName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.firewallRuleName = mapped
    }

    /**
     * @param value The name of the mongo cluster.
     */
    @JvmName("ivvqrgubgchpalps")
    public suspend fun mongoClusterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.mongoClusterName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("uigdoqijpakvklnm")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetFirewallRulePlainArgs = GetFirewallRulePlainArgs(
        firewallRuleName = firewallRuleName ?: throw PulumiNullFieldException("firewallRuleName"),
        mongoClusterName = mongoClusterName ?: throw PulumiNullFieldException("mongoClusterName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
