@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.GetSqlResourceSqlRoleDefinitionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName Cosmos DB database account name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property roleDefinitionId The GUID for the Role Definition.
 */
public data class GetSqlResourceSqlRoleDefinitionPlainArgs(
    public val accountName: String,
    public val resourceGroupName: String,
    public val roleDefinitionId: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.GetSqlResourceSqlRoleDefinitionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.inputs.GetSqlResourceSqlRoleDefinitionPlainArgs =
        com.pulumi.azurenative.documentdb.inputs.GetSqlResourceSqlRoleDefinitionPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .roleDefinitionId(roleDefinitionId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSqlResourceSqlRoleDefinitionPlainArgs].
 */
@PulumiTagMarker
public class GetSqlResourceSqlRoleDefinitionPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var resourceGroupName: String? = null

    private var roleDefinitionId: String? = null

    /**
     * @param value Cosmos DB database account name.
     */
    @JvmName("pkmgqsyimckgytgr")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("rswhnrdtafufuchc")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The GUID for the Role Definition.
     */
    @JvmName("shsttfdykywggknb")
    public suspend fun roleDefinitionId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.roleDefinitionId = mapped
    }

    internal fun build(): GetSqlResourceSqlRoleDefinitionPlainArgs =
        GetSqlResourceSqlRoleDefinitionPlainArgs(
            accountName = accountName ?: throw PulumiNullFieldException("accountName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            roleDefinitionId = roleDefinitionId ?: throw PulumiNullFieldException("roleDefinitionId"),
        )
}
