@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.GremlinDatabaseRestoreResourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Specific Gremlin Databases to restore.
 * @property databaseName The name of the gremlin database available for restore.
 * @property graphNames The names of the graphs available for restore.
 */
public data class GremlinDatabaseRestoreResourceArgs(
    public val databaseName: Output<String>? = null,
    public val graphNames: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.GremlinDatabaseRestoreResourceArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.inputs.GremlinDatabaseRestoreResourceArgs = com.pulumi.azurenative.documentdb.inputs.GremlinDatabaseRestoreResourceArgs.builder()
        .databaseName(databaseName?.applyValue({ args0 -> args0 }))
        .graphNames(graphNames?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [GremlinDatabaseRestoreResourceArgs].
 */
@PulumiTagMarker
public class GremlinDatabaseRestoreResourceArgsBuilder internal constructor() {
    private var databaseName: Output<String>? = null

    private var graphNames: Output<List<String>>? = null

    /**
     * @param value The name of the gremlin database available for restore.
     */
    @JvmName("fexaddeapgbrhqgd")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value The names of the graphs available for restore.
     */
    @JvmName("pdehdfcwbqsjpvfs")
    public suspend fun graphNames(`value`: Output<List<String>>) {
        this.graphNames = value
    }

    @JvmName("awhkpyuqxgspsluw")
    public suspend fun graphNames(vararg values: Output<String>) {
        this.graphNames = Output.all(values.asList())
    }

    /**
     * @param values The names of the graphs available for restore.
     */
    @JvmName("ccgthfehaegocwqi")
    public suspend fun graphNames(values: List<Output<String>>) {
        this.graphNames = Output.all(values)
    }

    /**
     * @param value The name of the gremlin database available for restore.
     */
    @JvmName("jephsmyjjlpwjlur")
    public suspend fun databaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value The names of the graphs available for restore.
     */
    @JvmName("fcijcxqiropocbsb")
    public suspend fun graphNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.graphNames = mapped
    }

    /**
     * @param values The names of the graphs available for restore.
     */
    @JvmName("iostblblwialcywe")
    public suspend fun graphNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.graphNames = mapped
    }

    internal fun build(): GremlinDatabaseRestoreResourceArgs = GremlinDatabaseRestoreResourceArgs(
        databaseName = databaseName,
        graphNames = graphNames,
    )
}
