@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.IncludedPathArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The paths that are included in indexing
 * @property indexes List of indexes for this path
 * @property path The path for which the indexing behavior applies to. Index paths typically start with root and end with wildcard (/path/*)
 * */
 */
public data class IncludedPathArgs(
    public val indexes: Output<List<IndexesArgs>>? = null,
    public val path: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.IncludedPathArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.inputs.IncludedPathArgs =
        com.pulumi.azurenative.documentdb.inputs.IncludedPathArgs.builder()
            .indexes(
                indexes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .path(path?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IncludedPathArgs].
 */
@PulumiTagMarker
public class IncludedPathArgsBuilder internal constructor() {
    private var indexes: Output<List<IndexesArgs>>? = null

    private var path: Output<String>? = null

    /**
     * @param value List of indexes for this path
     */
    @JvmName("lwvbeasdfcfgrfcc")
    public suspend fun indexes(`value`: Output<List<IndexesArgs>>) {
        this.indexes = value
    }

    @JvmName("repaqcdpawjlishe")
    public suspend fun indexes(vararg values: Output<IndexesArgs>) {
        this.indexes = Output.all(values.asList())
    }

    /**
     * @param values List of indexes for this path
     */
    @JvmName("adfdijtaosuucdhr")
    public suspend fun indexes(values: List<Output<IndexesArgs>>) {
        this.indexes = Output.all(values)
    }

    /**
     * @param value The path for which the indexing behavior applies to. Index paths typically start with root and end with wildcard (/path/*)
     * */
     */
    @JvmName("cimnpkmtqnuvyixh")
    public suspend fun path(`value`: Output<String>) {
        this.path = value
    }

    /**
     * @param value List of indexes for this path
     */
    @JvmName("cpstlnwcoewqnsil")
    public suspend fun indexes(`value`: List<IndexesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.indexes = mapped
    }

    /**
     * @param argument List of indexes for this path
     */
    @JvmName("holrstiiyqgkjggm")
    public suspend fun indexes(argument: List<suspend IndexesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { IndexesArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.indexes = mapped
    }

    /**
     * @param argument List of indexes for this path
     */
    @JvmName("vxmtbdhyxxnunmjq")
    public suspend fun indexes(vararg argument: suspend IndexesArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { IndexesArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.indexes = mapped
    }

    /**
     * @param argument List of indexes for this path
     */
    @JvmName("xkelvmbkmtiupxag")
    public suspend fun indexes(argument: suspend IndexesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(IndexesArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.indexes = mapped
    }

    /**
     * @param values List of indexes for this path
     */
    @JvmName("sjkdvlxvrperejbe")
    public suspend fun indexes(vararg values: IndexesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.indexes = mapped
    }

    /**
     * @param value The path for which the indexing behavior applies to. Index paths typically start with root and end with wildcard (/path/*)
     * */
     */
    @JvmName("jdbrwnmyxwysusoj")
    public suspend fun path(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.path = mapped
    }

    internal fun build(): IncludedPathArgs = IncludedPathArgs(
        indexes = indexes,
        path = path,
    )
}
