@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.IpAddressOrRangeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * IpAddressOrRange object
 * @property ipAddressOrRange A single IPv4 address or a single IPv4 address range in CIDR format. Provided IPs must be well-formatted and cannot be contained in one of the following ranges: 10.0.0.0/8, 100.64.0.0/10, 172.16.0.0/12, 192.168.0.0/16, since these are not enforceable by the IP address filter. Example of valid inputs: “23.40.210.245” or “23.40.210.0/8”.
 */
public data class IpAddressOrRangeArgs(
    public val ipAddressOrRange: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.IpAddressOrRangeArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.inputs.IpAddressOrRangeArgs =
        com.pulumi.azurenative.documentdb.inputs.IpAddressOrRangeArgs.builder()
            .ipAddressOrRange(ipAddressOrRange?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IpAddressOrRangeArgs].
 */
@PulumiTagMarker
public class IpAddressOrRangeArgsBuilder internal constructor() {
    private var ipAddressOrRange: Output<String>? = null

    /**
     * @param value A single IPv4 address or a single IPv4 address range in CIDR format. Provided IPs must be well-formatted and cannot be contained in one of the following ranges: 10.0.0.0/8, 100.64.0.0/10, 172.16.0.0/12, 192.168.0.0/16, since these are not enforceable by the IP address filter. Example of valid inputs: “23.40.210.245” or “23.40.210.0/8”.
     */
    @JvmName("phwdwdsyqiwixpjs")
    public suspend fun ipAddressOrRange(`value`: Output<String>) {
        this.ipAddressOrRange = value
    }

    /**
     * @param value A single IPv4 address or a single IPv4 address range in CIDR format. Provided IPs must be well-formatted and cannot be contained in one of the following ranges: 10.0.0.0/8, 100.64.0.0/10, 172.16.0.0/12, 192.168.0.0/16, since these are not enforceable by the IP address filter. Example of valid inputs: “23.40.210.245” or “23.40.210.0/8”.
     */
    @JvmName("yoisygspvitdqmbf")
    public suspend fun ipAddressOrRange(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipAddressOrRange = mapped
    }

    internal fun build(): IpAddressOrRangeArgs = IpAddressOrRangeArgs(
        ipAddressOrRange = ipAddressOrRange,
    )
}
