@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.LocationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A region in which the Azure Cosmos DB database account is deployed.
 * @property failoverPriority The failover priority of the region. A failover priority of 0 indicates a write region. The maximum value for a failover priority = (total number of regions - 1). Failover priority values must be unique for each of the regions in which the database account exists.
 * @property isZoneRedundant Flag to indicate whether or not this region is an AvailabilityZone region
 * @property locationName The name of the region.
 */
public data class LocationArgs(
    public val failoverPriority: Output<Int>? = null,
    public val isZoneRedundant: Output<Boolean>? = null,
    public val locationName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.LocationArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.inputs.LocationArgs =
        com.pulumi.azurenative.documentdb.inputs.LocationArgs.builder()
            .failoverPriority(failoverPriority?.applyValue({ args0 -> args0 }))
            .isZoneRedundant(isZoneRedundant?.applyValue({ args0 -> args0 }))
            .locationName(locationName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LocationArgs].
 */
@PulumiTagMarker
public class LocationArgsBuilder internal constructor() {
    private var failoverPriority: Output<Int>? = null

    private var isZoneRedundant: Output<Boolean>? = null

    private var locationName: Output<String>? = null

    /**
     * @param value The failover priority of the region. A failover priority of 0 indicates a write region. The maximum value for a failover priority = (total number of regions - 1). Failover priority values must be unique for each of the regions in which the database account exists.
     */
    @JvmName("iroyppaycufvxkjv")
    public suspend fun failoverPriority(`value`: Output<Int>) {
        this.failoverPriority = value
    }

    /**
     * @param value Flag to indicate whether or not this region is an AvailabilityZone region
     */
    @JvmName("cpllywwijbdobrnv")
    public suspend fun isZoneRedundant(`value`: Output<Boolean>) {
        this.isZoneRedundant = value
    }

    /**
     * @param value The name of the region.
     */
    @JvmName("ffxiamxuqvcmrpll")
    public suspend fun locationName(`value`: Output<String>) {
        this.locationName = value
    }

    /**
     * @param value The failover priority of the region. A failover priority of 0 indicates a write region. The maximum value for a failover priority = (total number of regions - 1). Failover priority values must be unique for each of the regions in which the database account exists.
     */
    @JvmName("lnubynrxwoxvbsxa")
    public suspend fun failoverPriority(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.failoverPriority = mapped
    }

    /**
     * @param value Flag to indicate whether or not this region is an AvailabilityZone region
     */
    @JvmName("dgoaycmijilvmpoc")
    public suspend fun isZoneRedundant(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isZoneRedundant = mapped
    }

    /**
     * @param value The name of the region.
     */
    @JvmName("tsvbgigsbqrtlrpv")
    public suspend fun locationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.locationName = mapped
    }

    internal fun build(): LocationArgs = LocationArgs(
        failoverPriority = failoverPriority,
        isZoneRedundant = isZoneRedundant,
        locationName = locationName,
    )
}
