@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.ManagedCassandraManagedServiceIdentityArgs.builder
import com.pulumi.azurenative.documentdb.kotlin.enums.ManagedCassandraResourceIdentityType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Identity for the resource.
 * @property type The type of the resource.
 */
public data class ManagedCassandraManagedServiceIdentityArgs(
    public val type: Output<Either<String, ManagedCassandraResourceIdentityType>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.ManagedCassandraManagedServiceIdentityArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.inputs.ManagedCassandraManagedServiceIdentityArgs =
        com.pulumi.azurenative.documentdb.inputs.ManagedCassandraManagedServiceIdentityArgs.builder()
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ManagedCassandraManagedServiceIdentityArgs].
 */
@PulumiTagMarker
public class ManagedCassandraManagedServiceIdentityArgsBuilder internal constructor() {
    private var type: Output<Either<String, ManagedCassandraResourceIdentityType>>? = null

    /**
     * @param value The type of the resource.
     */
    @JvmName("wxnibqpvijvkrwka")
    public suspend fun type(`value`: Output<Either<String, ManagedCassandraResourceIdentityType>>) {
        this.type = value
    }

    /**
     * @param value The type of the resource.
     */
    @JvmName("djagqmcvfukpmnxb")
    public suspend fun type(`value`: Either<String, ManagedCassandraResourceIdentityType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of the resource.
     */
    @JvmName("owguonbtdcurdtwl")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ManagedCassandraResourceIdentityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of the resource.
     */
    @JvmName("eancibvvtactwxgy")
    public fun type(`value`: ManagedCassandraResourceIdentityType) {
        val toBeMapped = Either.ofRight<String, ManagedCassandraResourceIdentityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ManagedCassandraManagedServiceIdentityArgs =
        ManagedCassandraManagedServiceIdentityArgs(
            type = type,
        )
}
