@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.MongoIndexOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Cosmos DB MongoDB collection index options
 * @property expireAfterSeconds Expire after seconds
 * @property unique Is unique or not
 */
public data class MongoIndexOptionsArgs(
    public val expireAfterSeconds: Output<Int>? = null,
    public val unique: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.MongoIndexOptionsArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.inputs.MongoIndexOptionsArgs =
        com.pulumi.azurenative.documentdb.inputs.MongoIndexOptionsArgs.builder()
            .expireAfterSeconds(expireAfterSeconds?.applyValue({ args0 -> args0 }))
            .unique(unique?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MongoIndexOptionsArgs].
 */
@PulumiTagMarker
public class MongoIndexOptionsArgsBuilder internal constructor() {
    private var expireAfterSeconds: Output<Int>? = null

    private var unique: Output<Boolean>? = null

    /**
     * @param value Expire after seconds
     */
    @JvmName("hjfpjwowxcudxlbt")
    public suspend fun expireAfterSeconds(`value`: Output<Int>) {
        this.expireAfterSeconds = value
    }

    /**
     * @param value Is unique or not
     */
    @JvmName("gwaeddjjatfdxgam")
    public suspend fun unique(`value`: Output<Boolean>) {
        this.unique = value
    }

    /**
     * @param value Expire after seconds
     */
    @JvmName("cspoxuyktvtiejua")
    public suspend fun expireAfterSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expireAfterSeconds = mapped
    }

    /**
     * @param value Is unique or not
     */
    @JvmName("uvpfagwciyyggnxg")
    public suspend fun unique(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.unique = mapped
    }

    internal fun build(): MongoIndexOptionsArgs = MongoIndexOptionsArgs(
        expireAfterSeconds = expireAfterSeconds,
        unique = unique,
    )
}
