@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.PermissionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The set of data plane operations permitted through this Role Definition.
 * @property dataActions An array of data actions that are allowed.
 * @property notDataActions An array of data actions that are denied.
 */
public data class PermissionArgs(
    public val dataActions: Output<List<String>>? = null,
    public val notDataActions: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.PermissionArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.inputs.PermissionArgs =
        com.pulumi.azurenative.documentdb.inputs.PermissionArgs.builder()
            .dataActions(dataActions?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .notDataActions(notDataActions?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [PermissionArgs].
 */
@PulumiTagMarker
public class PermissionArgsBuilder internal constructor() {
    private var dataActions: Output<List<String>>? = null

    private var notDataActions: Output<List<String>>? = null

    /**
     * @param value An array of data actions that are allowed.
     */
    @JvmName("qpyqdwtawcfiplcf")
    public suspend fun dataActions(`value`: Output<List<String>>) {
        this.dataActions = value
    }

    @JvmName("fbdifhrounfmfiet")
    public suspend fun dataActions(vararg values: Output<String>) {
        this.dataActions = Output.all(values.asList())
    }

    /**
     * @param values An array of data actions that are allowed.
     */
    @JvmName("tjhcllxvqfilqveg")
    public suspend fun dataActions(values: List<Output<String>>) {
        this.dataActions = Output.all(values)
    }

    /**
     * @param value An array of data actions that are denied.
     */
    @JvmName("wmoxpeffpyxuvxdh")
    public suspend fun notDataActions(`value`: Output<List<String>>) {
        this.notDataActions = value
    }

    @JvmName("erukbilchekbcwmj")
    public suspend fun notDataActions(vararg values: Output<String>) {
        this.notDataActions = Output.all(values.asList())
    }

    /**
     * @param values An array of data actions that are denied.
     */
    @JvmName("johbjdvhiuvmgpag")
    public suspend fun notDataActions(values: List<Output<String>>) {
        this.notDataActions = Output.all(values)
    }

    /**
     * @param value An array of data actions that are allowed.
     */
    @JvmName("fphfklminybdugud")
    public suspend fun dataActions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataActions = mapped
    }

    /**
     * @param values An array of data actions that are allowed.
     */
    @JvmName("jkvfvnqufvcknpgs")
    public suspend fun dataActions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataActions = mapped
    }

    /**
     * @param value An array of data actions that are denied.
     */
    @JvmName("xruqkavynhqrtwpl")
    public suspend fun notDataActions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notDataActions = mapped
    }

    /**
     * @param values An array of data actions that are denied.
     */
    @JvmName("dsuihfqlprminbua")
    public suspend fun notDataActions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.notDataActions = mapped
    }

    internal fun build(): PermissionArgs = PermissionArgs(
        dataActions = dataActions,
        notDataActions = notDataActions,
    )
}
