@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.PrivilegeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The set of data plane operations permitted through this Role Definition.
 * @property actions An array of actions that are allowed.
 * @property resource An Azure Cosmos DB Mongo DB Resource.
 */
public data class PrivilegeArgs(
    public val actions: Output<List<String>>? = null,
    public val resource: Output<PrivilegeResourceArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.PrivilegeArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.inputs.PrivilegeArgs =
        com.pulumi.azurenative.documentdb.inputs.PrivilegeArgs.builder()
            .actions(actions?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .resource(resource?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [PrivilegeArgs].
 */
@PulumiTagMarker
public class PrivilegeArgsBuilder internal constructor() {
    private var actions: Output<List<String>>? = null

    private var resource: Output<PrivilegeResourceArgs>? = null

    /**
     * @param value An array of actions that are allowed.
     */
    @JvmName("etwafkqagmtmwxcw")
    public suspend fun actions(`value`: Output<List<String>>) {
        this.actions = value
    }

    @JvmName("ocmciqblmqrniloc")
    public suspend fun actions(vararg values: Output<String>) {
        this.actions = Output.all(values.asList())
    }

    /**
     * @param values An array of actions that are allowed.
     */
    @JvmName("votlpjjdhupwhsjs")
    public suspend fun actions(values: List<Output<String>>) {
        this.actions = Output.all(values)
    }

    /**
     * @param value An Azure Cosmos DB Mongo DB Resource.
     */
    @JvmName("verbvnspyyxaigqk")
    public suspend fun resource(`value`: Output<PrivilegeResourceArgs>) {
        this.resource = value
    }

    /**
     * @param value An array of actions that are allowed.
     */
    @JvmName("mtaboatfnxuoxovy")
    public suspend fun actions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.actions = mapped
    }

    /**
     * @param values An array of actions that are allowed.
     */
    @JvmName("panjylytliypukjs")
    public suspend fun actions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actions = mapped
    }

    /**
     * @param value An Azure Cosmos DB Mongo DB Resource.
     */
    @JvmName("hctykaxckqefmnis")
    public suspend fun resource(`value`: PrivilegeResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resource = mapped
    }

    /**
     * @param argument An Azure Cosmos DB Mongo DB Resource.
     */
    @JvmName("blbiaqetlakukixl")
    public suspend fun resource(argument: suspend PrivilegeResourceArgsBuilder.() -> Unit) {
        val toBeMapped = PrivilegeResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.resource = mapped
    }

    internal fun build(): PrivilegeArgs = PrivilegeArgs(
        actions = actions,
        resource = resource,
    )
}
