@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Ldap authentication method properties. This feature is in preview.
 * @property connectionTimeoutInMs Timeout for connecting to the LDAP server in miliseconds. The default is 5000 ms.
 * @property searchBaseDistinguishedName Distinguished name of the object to start the recursive search of users from.
 * @property searchFilterTemplate Template to use for searching. Defaults to (cn=%s) where %s will be replaced by the username used to login.
 * @property serverCertificates
 * @property serverHostname Hostname of the LDAP server.
 * @property serverPort Port of the LDAP server.
 * @property serviceUserDistinguishedName Distinguished name of the look up user account, who can look up user details on authentication.
 * @property serviceUserPassword Password of the look up user.
 */
public data class AuthenticationMethodLdapPropertiesResponse(
    public val connectionTimeoutInMs: Int? = null,
    public val searchBaseDistinguishedName: String? = null,
    public val searchFilterTemplate: String? = null,
    public val serverCertificates: List<CertificateResponse>? = null,
    public val serverHostname: String? = null,
    public val serverPort: Int? = null,
    public val serviceUserDistinguishedName: String? = null,
    public val serviceUserPassword: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.documentdb.outputs.AuthenticationMethodLdapPropertiesResponse): AuthenticationMethodLdapPropertiesResponse = AuthenticationMethodLdapPropertiesResponse(
            connectionTimeoutInMs = javaType.connectionTimeoutInMs().map({ args0 -> args0 }).orElse(null),
            searchBaseDistinguishedName = javaType.searchBaseDistinguishedName().map({ args0 ->
                args0
            }).orElse(null),
            searchFilterTemplate = javaType.searchFilterTemplate().map({ args0 -> args0 }).orElse(null),
            serverCertificates = javaType.serverCertificates().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.documentdb.kotlin.outputs.CertificateResponse.Companion.toKotlin(args0)
                })
            }),
            serverHostname = javaType.serverHostname().map({ args0 -> args0 }).orElse(null),
            serverPort = javaType.serverPort().map({ args0 -> args0 }).orElse(null),
            serviceUserDistinguishedName = javaType.serviceUserDistinguishedName().map({ args0 ->
                args0
            }).orElse(null),
            serviceUserPassword = javaType.serviceUserPassword().map({ args0 -> args0 }).orElse(null),
        )
    }
}
