@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The object representing the state of the migration between the backup policies.
 * @property startTime Time at which the backup policy migration started (ISO-8601 format).
 * @property status Describes the status of migration between backup policy types.
 * @property targetType Describes the target backup policy type of the backup policy migration.
 */
public data class BackupPolicyMigrationStateResponse(
    public val startTime: String? = null,
    public val status: String? = null,
    public val targetType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.documentdb.outputs.BackupPolicyMigrationStateResponse): BackupPolicyMigrationStateResponse = BackupPolicyMigrationStateResponse(
            startTime = javaType.startTime().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            targetType = javaType.targetType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
