@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Cosmos DB capability object
 * @property name Name of the Cosmos DB capability. For example, "name": "EnableCassandra". Current values also include "EnableTable" and "EnableGremlin".
 */
public data class CapabilityResponse(
    public val name: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.documentdb.outputs.CapabilityResponse): CapabilityResponse = CapabilityResponse(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
        )
    }
}
