@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 * The object that represents all properties related to capacity enforcement on an account.
 * @property totalThroughputLimit The total throughput limit imposed on the account. A totalThroughputLimit of 2000 imposes a strict limit of max throughput that can be provisioned on that account to be 2000. A totalThroughputLimit of -1 indicates no limits on provisioning of throughput.
 */
public data class CapacityResponse(
    public val totalThroughputLimit: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.documentdb.outputs.CapacityResponse): CapacityResponse = CapacityResponse(
            totalThroughputLimit = javaType.totalThroughputLimit().map({ args0 -> args0 }).orElse(null),
        )
    }
}
