@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * Cosmos DB Cassandra table schema
 * @property clusterKeys List of cluster key.
 * @property columns List of Cassandra table columns.
 * @property partitionKeys List of partition key.
 */
public data class CassandraSchemaResponse(
    public val clusterKeys: List<ClusterKeyResponse>? = null,
    public val columns: List<ColumnResponse>? = null,
    public val partitionKeys: List<CassandraPartitionKeyResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.documentdb.outputs.CassandraSchemaResponse): CassandraSchemaResponse = CassandraSchemaResponse(
            clusterKeys = javaType.clusterKeys().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.documentdb.kotlin.outputs.ClusterKeyResponse.Companion.toKotlin(args0)
                })
            }),
            columns = javaType.columns().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.documentdb.kotlin.outputs.ColumnResponse.Companion.toKotlin(args0)
                })
            }),
            partitionKeys = javaType.partitionKeys().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.documentdb.kotlin.outputs.CassandraPartitionKeyResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
