@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * .
 * @property clientEncryptionKeyId The identifier of the Client Encryption Key to be used to encrypt the path.
 * @property encryptionAlgorithm The encryption algorithm which will be used. Eg - AEAD_AES_256_CBC_HMAC_SHA256.
 * @property encryptionType The type of encryption to be performed. Eg - Deterministic, Randomized.
 * @property path Path that needs to be encrypted.
 */
public data class ClientEncryptionIncludedPathResponse(
    public val clientEncryptionKeyId: String,
    public val encryptionAlgorithm: String,
    public val encryptionType: String,
    public val path: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.documentdb.outputs.ClientEncryptionIncludedPathResponse): ClientEncryptionIncludedPathResponse = ClientEncryptionIncludedPathResponse(
            clientEncryptionKeyId = javaType.clientEncryptionKeyId(),
            encryptionAlgorithm = javaType.encryptionAlgorithm(),
            encryptionType = javaType.encryptionType(),
            path = javaType.path(),
        )
    }
}
