@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.outputs

import kotlin.Int
import kotlin.Suppress
import kotlin.collections.List

/**
 * Cosmos DB client encryption policy.
 * @property includedPaths Paths of the item that need encryption along with path-specific settings.
 * @property policyFormatVersion Version of the client encryption policy definition. Supported versions are 1 and 2. Version 2 supports id and partition key path encryption.
 */
public data class ClientEncryptionPolicyResponse(
    public val includedPaths: List<ClientEncryptionIncludedPathResponse>,
    public val policyFormatVersion: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.documentdb.outputs.ClientEncryptionPolicyResponse): ClientEncryptionPolicyResponse = ClientEncryptionPolicyResponse(
            includedPaths = javaType.includedPaths().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.documentdb.kotlin.outputs.ClientEncryptionIncludedPathResponse.Companion.toKotlin(args0)
                })
            }),
            policyFormatVersion = javaType.policyFormatVersion(),
        )
    }
}
