@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property order Sort order for composite paths.
 * @property path The path for which the indexing behavior applies to. Index paths typically start with root and end with wildcard (/path/*)
 * */
 */
public data class CompositePathResponse(
    public val order: String? = null,
    public val path: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.documentdb.outputs.CompositePathResponse): CompositePathResponse = CompositePathResponse(
            order = javaType.order().map({ args0 -> args0 }).orElse(null),
            path = javaType.path().map({ args0 -> args0 }).orElse(null),
        )
    }
}
