@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The conflict resolution policy for the container.
 * @property conflictResolutionPath The conflict resolution path in the case of LastWriterWins mode.
 * @property conflictResolutionProcedure The procedure to resolve conflicts in the case of custom mode.
 * @property mode Indicates the conflict resolution mode.
 */
public data class ConflictResolutionPolicyResponse(
    public val conflictResolutionPath: String? = null,
    public val conflictResolutionProcedure: String? = null,
    public val mode: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.documentdb.outputs.ConflictResolutionPolicyResponse): ConflictResolutionPolicyResponse = ConflictResolutionPolicyResponse(
            conflictResolutionPath = javaType.conflictResolutionPath().map({ args0 -> args0 }).orElse(null),
            conflictResolutionProcedure = javaType.conflictResolutionProcedure().map({ args0 ->
                args0
            }).orElse(null),
            mode = javaType.mode().map({ args0 -> args0 }).orElse(null),
        )
    }
}
