@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * The consistency policy for the Cosmos DB database account.
 * @property defaultConsistencyLevel The default consistency level and configuration settings of the Cosmos DB account.
 * @property maxIntervalInSeconds When used with the Bounded Staleness consistency level, this value represents the time amount of staleness (in seconds) tolerated. Accepted range for this value is 5 - 86400. Required when defaultConsistencyPolicy is set to 'BoundedStaleness'.
 * @property maxStalenessPrefix When used with the Bounded Staleness consistency level, this value represents the number of stale requests tolerated. Accepted range for this value is 1 – 2,147,483,647. Required when defaultConsistencyPolicy is set to 'BoundedStaleness'.
 */
public data class ConsistencyPolicyResponse(
    public val defaultConsistencyLevel: String,
    public val maxIntervalInSeconds: Int? = null,
    public val maxStalenessPrefix: Double? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.documentdb.outputs.ConsistencyPolicyResponse): ConsistencyPolicyResponse = ConsistencyPolicyResponse(
            defaultConsistencyLevel = javaType.defaultConsistencyLevel(),
            maxIntervalInSeconds = javaType.maxIntervalInSeconds().map({ args0 -> args0 }).orElse(null),
            maxStalenessPrefix = javaType.maxStalenessPrefix().map({ args0 -> args0 }).orElse(null),
        )
    }
}
